/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipConsumer;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.hammerlib.util.mcf.NormalizedTicker;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.compat._abilities.SFAbilities;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.init.TilesSF;
import org.zeith.solarflux.items.data.PanelDataComponent;
import org.zeith.solarflux.items.upgrades._base.ISunIntensityMod;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.items.upgrades._base.UpgradeSystem;
import org.zeith.solarflux.net.PacketRequestSolarIntensity;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanelInstance;
import org.zeith.solarflux.util.BlockPosFace;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SolarPanelTile
extends TileSyncableTickable
implements IEnergyStorage,
IContainerTile,
ISolarPanelTile,
ITooltipTile {
    @NBTSerializable(value="Energy")
    public long energy;
    public long currentGeneration;
    public float sunIntensity = 1.0E-30f;
    private SolarPanel delegate;
    private SolarPanelInstance instance;
    @NBTSerializable(value="Upgrades")
    public final SimpleInventory upgradeInventory = new SimpleInventory(5);
    @NBTSerializable(value="Chargeable")
    public final SimpleInventory chargeInventory = new SimpleInventory(1);
    public final List<BlockPosFace> traversal = new ArrayList<BlockPosFace>();
    public final SimpleAttributeProperty generation = new SimpleAttributeProperty();
    public final SimpleAttributeProperty transfer = new SimpleAttributeProperty();
    public final SimpleAttributeProperty capacity = new SimpleAttributeProperty();
    protected int refreshTimer = 0;
    List<ResourceLocation> tickedUpgrades = new ArrayList<ResourceLocation>();
    private static final Direction[] DIRECTIONS_NO_UP = (Direction[])Direction.stream().filter(f -> f != Direction.UP).toArray(Direction[]::new);
    private static final Direction[] DIRECTIONS_HORIZONTAL = (Direction[])Direction.stream().filter(f -> f.getAxis() != Direction.Axis.Y).toArray(Direction[]::new);
    protected final NormalizedTicker ticker = NormalizedTicker.create(this::normTick);
    int effCacheTime;
    float effCache;
    public boolean cache$seeSky;
    public byte cache$seeSkyTimer;
    int voxelTimer = 0;
    VoxelShape shape;

    @SubscribeEvent
    public static void capabilities(RegisterCapabilitiesEvent e) {
        e.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, TilesSF.SOLAR_PANEL, (object, context) -> object);
        e.registerBlockEntity(Capabilities.ItemHandler.BLOCK, TilesSF.SOLAR_PANEL, (object, context) -> object.chargeInventory);
    }

    public SolarPanelTile(BlockPos pos, BlockState state) {
        super(TilesSF.SOLAR_PANEL, pos, state);
        this.onConstructed();
    }

    protected void onConstructed() {
    }

    public void setRemoved() {
        super.setRemoved();
        this.setRemovedSFR();
    }

    public void setRemovedSFR() {
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onChunkUnloadedSFR();
    }

    public void onChunkUnloadedSFR() {
    }

    public void clearRemoved() {
        super.clearRemoved();
        this.clearRemovedSFR();
    }

    public void clearRemovedSFR() {
    }

    @Override
    public int getUpgrades(Item type) {
        int c = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            ItemStack stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != type) continue;
            c += stack.getCount();
        }
        return c;
    }

    @Override
    public Stream<Tuple2<UpgradeItem, ItemStack>> getUpgrades() {
        return this.upgradeInventory.stream().map(i -> {
            Tuple2 tuple2;
            Item patt0$temp;
            if (!i.isEmpty() && (patt0$temp = i.getItem()) instanceof UpgradeItem) {
                UpgradeItem u = (UpgradeItem)patt0$temp;
                tuple2 = Tuples.immutable((Object)((Object)u), (Object)i);
            } else {
                tuple2 = null;
            }
            return tuple2;
        }).filter(Objects::nonNull);
    }

    @Override
    public SolarPanel getDelegate() {
        if (this.delegate == null) {
            Block blk = this.getBlockState().getBlock();
            this.delegate = blk instanceof SolarPanelBlock ? ((SolarPanelBlock)blk).panel : SolarPanelsSF.CORE_PANELS[0];
        }
        return this.delegate;
    }

    @Override
    public SolarPanelInstance getInstance() {
        if (this.instance == null || this.instance.getDelegate() != this.getDelegate()) {
            this.instance = this.getDelegate().createInstance(this);
        }
        return this.instance;
    }

    public void tickUpgrades() {
        ItemStack stack;
        int i;
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            UpgradeItem upgrade;
            stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof UpgradeItem && (upgrade = (UpgradeItem)item).canStayInPanel(this, stack, this.upgradeInventory)) {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
                if (this.tickedUpgrades.contains(id)) continue;
                upgrade.update(this, stack, this.getUpgrades(upgrade));
                this.tickedUpgrades.add(id);
                continue;
            }
            ItemStack s = this.upgradeInventory.getStackInSlot(i);
            s.copy();
            this.upgradeInventory.setStackInSlot(i, ItemStack.EMPTY);
            if (!this.isOnServer()) continue;
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack));
        }
        if (this.energy > 0L && this.getInstance() != null) {
            for (i = 0; i < this.chargeInventory.getSlots(); ++i) {
                IEnergyStorage e;
                stack = this.chargeInventory.getStackInSlot(i);
                if (stack.isEmpty() || (e = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null || e.getEnergyStored() >= e.getMaxEnergyStored()) continue;
                this.transfer.setBaseValue(this.getInstance().transfer);
                int transfer = this.transfer.getValueI();
                this.energy -= (long)e.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
            }
        }
        this.tickedUpgrades.clear();
    }

    public void update() {
        this.ticker.tick(this.level);
    }

    public boolean atTickRate(int rate) {
        return this.ticker.atTickRate(rate);
    }

    public void normTick(int suppressed) {
        Block blk;
        if (this.voxelTimer > 0) {
            --this.voxelTimer;
        }
        if (!((blk = this.getBlockState().getBlock()) instanceof SolarPanelBlock)) {
            return;
        }
        SolarPanelBlock spb = (SolarPanelBlock)blk;
        this.delegate = spb.panel;
        if (this.cache$seeSkyTimer > 0) {
            this.cache$seeSkyTimer = (byte)(this.cache$seeSkyTimer - 1);
        }
        if (this.refreshTimer > 0) {
            --this.refreshTimer;
        }
        if (this.level.isClientSide) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L) {
            this.traversal.clear();
        }
        this.tickUpgrades();
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI() * suppressed;
        long gen = this.getGeneration();
        this.capacity.setBaseValue(this.getInstance().cap);
        this.energy += Math.min(this.capacity.getValueL() - this.energy, gen * (long)suppressed);
        this.currentGeneration = gen;
        this.energy = Math.clamp(this.energy, 0L, this.capacity.getValueL());
        for (Direction hor : DIRECTIONS_HORIZONTAL) {
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(hor));
            if (!(tile instanceof SolarPanelTile)) continue;
            SolarPanelTile spt = (SolarPanelTile)tile;
            this.autoBalanceEnergy(spt);
        }
        for (Direction hor : DIRECTIONS_NO_UP) {
            IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(hor), (Object)hor.getOpposite());
            if (storage == null) continue;
            if (storage.canReceive()) {
                this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
            }
            if (this.energy < 1L) break;
        }
        if (!this.traversal.isEmpty() && this.energy > 0L) {
            for (BlockPosFace traverse : this.traversal) {
                IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, traverse.pos, (Object)traverse.face);
                if (storage == null) continue;
                if (storage.canReceive()) {
                    this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), Math.round((float)transfer * traverse.rate)), false);
                }
                if (this.energy >= 1L) continue;
                break;
            }
        }
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        if (this.effCacheTime > 0) {
            --this.effCacheTime;
        }
    }

    @Override
    public int getGeneration() {
        float eff = this.effCache;
        if (this.effCacheTime <= 0) {
            eff = this.getInstance().computeSunIntensity(this);
            for (ISunIntensityMod mod : UpgradeSystem.findAbilitiesIn(this, SFAbilities.ITEM_UPGRADE_SUN_INTENSITY_MUL)) {
                eff = mod.applySunIntensityModifier(this, eff);
            }
            float raining = this.level.getRainLevel(1.0f);
            raining = raining > 0.2f ? (raining - 0.2f) / 0.8f : 0.0f;
            raining = (float)Math.sin((double)raining * Math.PI / 2.0);
            eff *= 1.0f - raining * (1.0f - SolarPanelsSF.RAIN_MULTIPLIER);
            float thundering = this.level.getThunderLevel(1.0f);
            thundering = thundering > 0.75f ? (thundering - 0.75f) / 0.25f : 0.0f;
            thundering = (float)Math.sin((double)thundering * Math.PI / 2.0);
            this.effCache = eff *= 1.0f - thundering * (1.0f - SolarPanelsSF.THUNDER_MULTIPLIER);
            this.effCacheTime = 5;
        }
        if (!this.level.isClientSide) {
            this.sunIntensity = eff;
        }
        float gen = (float)this.getInstance().gen * eff;
        this.generation.setBaseValue(gen);
        return this.generation.getValueI();
    }

    public int autoBalanceEnergy(SolarPanelTile solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0) {
            return this.extractEnergy(solar.receiveEnergyInternal(this.extractEnergy(solar.receiveEnergyInternal(delta / 2, true), true), false), false);
        }
        return 0;
    }

    @Override
    public boolean doesSeeSky() {
        if (this.cache$seeSkyTimer < 1) {
            this.cache$seeSkyTimer = (byte)20;
            this.cache$seeSky = this.level != null && this.level.getBrightness(LightLayer.SKY, this.worldPosition) > 0 && this.level.canSeeSky(this.worldPosition.above());
        }
        return this.cache$seeSky;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public BlockPos pos() {
        return this.worldPosition;
    }

    @Override
    public List<BlockPosFace> traversal() {
        return this.traversal;
    }

    @Override
    public long energy() {
        return this.energy;
    }

    @Override
    public void energy(long newEnergy) {
        this.energy = Math.clamp(newEnergy, 0L, this.capacity.getValueL());
        this.setChanged();
    }

    @Override
    public SimpleAttributeProperty generation() {
        return this.generation;
    }

    @Override
    public SimpleAttributeProperty transfer() {
        return this.transfer;
    }

    @Override
    public SimpleAttributeProperty capacity() {
        return this.capacity;
    }

    public void resetVoxelShape() {
        this.shape = null;
    }

    public VoxelShape getShape(SolarPanelBlock block) {
        if (this.shape == null || this.voxelTimer <= 0) {
            this.shape = block.recalcShape((BlockGetter)this.level, this.worldPosition);
            this.voxelTimer = 20;
        }
        return this.shape;
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return new SolarPanelContainer(windowId, player.getInventory(), this);
    }

    @Nullable
    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(transfer, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
            this.setChanged();
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        this.capacity.setBaseValue(this.getInstance().cap);
        long cap = this.capacity.getValueL();
        int energyReceived = Math.min((int)Math.min(cap - this.energy, Integer.MAX_VALUE), Math.min(transfer, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
            this.setChanged();
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energy, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getInstance().cap, Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public ItemStack generateItem(ItemLike item) {
        ItemStack stack = new ItemStack(item);
        long reducedEnergy = this.energy - Math.round((double)this.energy * SolarPanelsSF.LOOSE_ENERGY / 100.0);
        if (reducedEnergy > 0L || !this.chargeInventory.isEmpty() || !this.upgradeInventory.isEmpty()) {
            stack.set((DataComponentType)PanelDataComponent.TYPE.get(), (Object)new PanelDataComponent(reducedEnergy, List.copyOf(this.upgradeInventory.items.stream().map(ItemStack::copy).toList()), List.copyOf(this.chargeInventory.items.stream().map(ItemStack::copy).toList())));
        }
        return stack;
    }

    public PanelDataComponent saveToComponent() {
        return new PanelDataComponent(this.energy, List.copyOf(this.upgradeInventory.items.stream().map(ItemStack::copy).toList()), List.copyOf(this.chargeInventory.items.stream().map(ItemStack::copy).toList()));
    }

    public void loadFromItem(PanelDataComponent component) {
        this.energy = component.energy();
        this.load(component.upgrades(), this.upgradeInventory);
        this.load(component.chargeable(), this.chargeInventory);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.loadFromItem((PanelDataComponent)input.getOrDefault((DataComponentType)PanelDataComponent.TYPE.get(), (Object)PanelDataComponent.EMPTY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)PanelDataComponent.TYPE.get(), (Object)this.saveToComponent());
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("HL");
    }

    protected void load(List<ItemStack> from, SimpleInventory target) {
        int j = Math.min(from.size(), target.getSlots());
        for (int i = 0; i < j; ++i) {
            target.setStackInSlot(i, from.get(i).copy());
        }
    }

    public boolean isEngineSupported(EnumTooltipEngine engine) {
        return HLConstants.enableHammerLibTooltipEngine && SolarPanelsSF.enableHammerLibTooltips || engine != EnumTooltipEngine.HAMMER_LIB;
    }

    public void addTooltip(ITooltipConsumer consumer, Player player) {
        if (this.level().isClientSide() && (this.refreshTimer <= 0 || this.sunIntensity == 1.0E-30f)) {
            this.refreshTimer = 5;
            Network.sendToServer((IPacket)new PacketRequestSolarIntensity(this.pos(), 0.0f));
            if (this.sunIntensity == 1.0E-30f) {
                return;
            }
        }
        consumer.addLine((Component)Component.literal((String)Component.translatable((String)"info.solarflux.sun.intensity").getString().replaceFirst(":.*$", ":")));
        ProgressBar bar = new ProgressBar(100L).withStyle(ProgressBar.ProgressBarStyle.FORGE_ENERGY_STYLE).setProgress((long)Math.round(100.0f * this.sunIntensity)).withNumberFormat(EnumNumberFormat.FULL);
        bar.filledMainColor = -1984453;
        bar.filledAlternateColor = -7975160;
        bar.suffix = "%";
        consumer.addBar(bar);
    }

    public void setDelegate(SolarPanel delegate) {
        this.delegate = delegate;
    }
}

