/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ElasticAnimation {
    private static final int MAX_SQUISH_TICKS = 10;
    private float squosh = 1.0f;
    private float oldSquosh = 1.0f;
    private float squish = 1.0f;
    private float oldSquish = 1.0f;
    private int squishTicks = 0;

    public void tick(Vec3 movement) {
        this.squishTicks = Math.max(0, this.squishTicks - 1);
        double speed = Mth.clamp((double)(movement.lengthSqr() * 3.0), (double)0.0, (double)1.0);
        this.oldSquosh = this.squosh;
        this.oldSquish = this.squish;
        this.squosh = (float)Math.max(0.3, 1.0 + speed - (double)(1.0f * (float)this.squishTicks / 10.0f));
        this.squish = 1.0f / Mth.sqrt((float)this.squosh);
    }

    public Vector3f getScale(float partialTicks) {
        float squishFactor = Mth.lerp((float)partialTicks, (float)this.oldSquish, (float)this.squish);
        float squoshFactor = Mth.lerp((float)partialTicks, (float)this.oldSquosh, (float)this.squosh);
        return new Vector3f(squishFactor, squishFactor, squoshFactor);
    }

    public void setSquishedDown() {
        this.squishTicks = 10;
    }
}

