/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.google.common.base.Strings;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public abstract class AbstractComputerBlockEntity
extends BlockEntity
implements Nameable,
MenuConstructor {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private static final String NBT_CAPACITY = "Capacity";
    private @Nullable UUID instanceID = null;
    private int computerID = -1;
    protected @Nullable String label = null;
    protected long storageCapacity = -1L;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final ComponentAccess<IPeripheral> peripherals = PlatformHelper.get().createPeripheralAccess(this, d -> this.invalidSides |= 1 << d.ordinal());
    private LockCode lockCode = LockCode.NO_LOCK;
    private final ComputerFamily family;

    public AbstractComputerBlockEntity(BlockEntityType<? extends AbstractComputerBlockEntity> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
    }

    protected void unload() {
        if (this.getLevel().isClientSide) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = null;
    }

    public void setRemoved() {
        super.setRemoved();
        this.unload();
    }

    protected float getInteractRange() {
        return 4.0f;
    }

    public boolean isUsable(Player player) {
        return this.getFamily().checkUsable(player) && BaseContainerBlockEntity.canUnlock((Player)player, (LockCode)this.lockCode, (Component)this.getDisplayName()) && Container.stillValidBlockEntity((BlockEntity)this, (Player)player, (float)this.getInteractRange());
    }

    protected void serverTick() {
        String newLabel;
        if (this.getLevel().isClientSide) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if (!DirectionUtil.isSet(this.invalidSides, direction)) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        boolean newOn = computer.isOn();
        if (this.on != newOn) {
            this.on = newOn;
            this.setChanged();
        }
        if (!Objects.equals(this.label, newLabel = computer.getLabel())) {
            this.label = newLabel;
            BlockEntityHelpers.updateBlock(this);
        }
        this.updateBlockState(computer.getState());
        int changes = computer.pollRedstoneChanges();
        if (changes != 0) {
            for (Direction direction : DirectionUtil.FACINGS) {
                if ((changes & 1 << this.remapToLocalSide(direction).ordinal()) == 0) continue;
                this.updateRedstoneTo(direction);
            }
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.computerID >= 0) {
            nbt.putInt(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.putString(NBT_LABEL, this.label);
        }
        if (this.storageCapacity > 0L) {
            nbt.putLong(NBT_CAPACITY, this.storageCapacity);
        }
        nbt.putBoolean(NBT_ON, this.on);
        this.lockCode.addToTag(nbt);
        super.saveAdditional(nbt, registries);
    }

    public final void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (this.level != null && this.level.isClientSide) {
            this.loadClient(nbt, registries);
        } else {
            this.loadServer(nbt, registries);
        }
    }

    protected void loadServer(CompoundTag nbt, HolderLookup.Provider registries) {
        this.computerID = nbt.contains(NBT_ID) ? nbt.getInt(NBT_ID) : -1;
        this.label = nbt.contains(NBT_LABEL) ? nbt.getString(NBT_LABEL) : null;
        this.storageCapacity = nbt.contains(NBT_CAPACITY, 99) ? nbt.getLong(NBT_CAPACITY) : -1L;
        this.on = this.startOn = nbt.getBoolean(NBT_ON);
        this.lockCode = LockCode.fromTag((CompoundTag)nbt);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput component) {
        super.applyImplicitComponents(component);
        this.label = DataComponentUtil.getCustomName((Component)component.get(DataComponents.CUSTOM_NAME));
        this.computerID = NonNegativeId.getId((NonNegativeId)component.get((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get()));
        this.storageCapacity = StorageCapacity.getOrDefault((StorageCapacity)component.get((DataComponentType)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), -1L);
        this.lockCode = (LockCode)component.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.collectSafeComponents(builder);
        if (this.lockCode != LockCode.NO_LOCK) {
            builder.set(DataComponents.LOCK, (Object)this.lockCode);
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void collectSafeComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModRegistry.DataComponents.COMPUTER_ID.get(), (Object)NonNegativeId.of(this.computerID));
        builder.set(DataComponents.CUSTOM_NAME, this.label == null ? null : Component.literal((String)this.label));
        builder.set((DataComponentType)ModRegistry.DataComponents.STORAGE_CAPACITY.get(), (Object)(this.storageCapacity > 0L ? new StorageCapacity(this.storageCapacity) : null));
    }

    @Deprecated
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(NBT_ID);
        tag.remove(NBT_LABEL);
        tag.remove(NBT_CAPACITY);
        tag.remove("Lock");
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract Direction getDirection();

    protected ComputerSide remapToLocalSide(Direction globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInput(ServerComputer computer, Direction dir, BlockPos targetPos) {
        Direction offsetSide = dir.getOpposite();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.getLevel(), targetPos, dir), BundledRedstone.getOutput(this.getLevel(), targetPos, offsetSide));
    }

    private void refreshPeripheral(ServerComputer computer, Direction dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        IPeripheral peripheral = this.peripherals.get(dir);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(ServerComputer computer) {
        BlockPos pos = this.getBlockPos();
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.relative(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    public void neighborChanged(BlockPos neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            BlockPos offset = this.getBlockPos().relative(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, this.getBlockPos().relative(dir));
        }
        this.invalidSides = 63;
    }

    public void neighbourShapeChanged(Direction direction) {
        this.invalidSides |= 1 << direction.ordinal();
    }

    protected void updateRedstoneTo(Direction direction) {
        RedstoneUtil.propagateRedstoneOutput(this.getLevel(), this.getBlockPos(), direction);
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateRedstoneInput(computer, direction, this.getBlockPos().relative(direction));
        }
    }

    public void updateRedstone() {
        for (Direction dir : DirectionUtil.FACINGS) {
            this.updateRedstoneTo(dir);
        }
    }

    public final int getComputerID() {
        return this.computerID;
    }

    public final @Nullable String getLabel() {
        return this.label;
    }

    public final boolean isAdminOnly() {
        return this.getBlockState().getBlock() instanceof GameMasterBlock;
    }

    public final void setComputerID(int id) {
        if (this.getLevel().isClientSide || this.computerID == id) {
            return;
        }
        this.computerID = id;
        BlockEntityHelpers.updateBlock(this);
    }

    public final void setLabel(@Nullable String label) {
        if (this.getLevel().isClientSide || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        BlockEntityHelpers.updateBlock(this);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public final ServerComputer createServerComputer() {
        MinecraftServer server = this.getLevel().getServer();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(server, "computer");
                BlockEntityHelpers.updateBlock(this);
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    protected abstract ServerComputer createComputer(int var1);

    public @Nullable ServerComputer getServerComputer() {
        return this.getLevel().isClientSide || this.getLevel().getServer() == null ? null : ServerContext.get(this.getLevel().getServer()).registry().get(this.instanceID);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        if (this.computerID >= 0) {
            nbt.putInt(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.putString(NBT_LABEL, this.label);
        }
        if (this.storageCapacity > 0L) {
            nbt.putLong(NBT_CAPACITY, this.storageCapacity);
        }
        return nbt;
    }

    protected void loadClient(CompoundTag nbt, HolderLookup.Provider registries) {
        this.computerID = nbt.contains(NBT_ID) ? nbt.getInt(NBT_ID) : -1;
        this.label = nbt.contains(NBT_LABEL) ? nbt.getString(NBT_LABEL) : null;
        this.storageCapacity = nbt.contains(NBT_CAPACITY, 99) ? nbt.getLong(NBT_CAPACITY) : -1L;
    }

    protected void transferStateFrom(AbstractComputerBlockEntity copy) {
        if (copy.computerID != this.computerID || !Objects.equals(copy.instanceID, this.instanceID)) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.storageCapacity = copy.storageCapacity;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            BlockEntityHelpers.updateBlock(this);
        }
        copy.instanceID = null;
    }

    public Component getName() {
        return this.hasCustomName() ? Component.literal((String)this.label) : Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public boolean hasCustomName() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    public @Nullable Component getCustomName() {
        return this.hasCustomName() ? Component.literal((String)this.label) : null;
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public boolean onlyOpCanSetNbt() {
        return this.isAdminOnly();
    }
}

