/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.JsonConfig;

public class ThemeHelper
extends SimpleJsonResourceReloadListener
implements IThemeHelper {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    public static final ResourceLocation ID = JadeIds.JADE("themes");
    public static final MutableObject<Theme> theme = new MutableObject();
    private static final Int2ObjectMap<Style> styleCache = new Int2ObjectOpenHashMap(6);
    private final Map<ResourceLocation, Theme> themes = Maps.newTreeMap(Comparator.comparing(ResourceLocation::toString));
    private final MinMaxBounds.Ints allowedVersions = MinMaxBounds.Ints.between((int)100, (int)199);
    private final Style[] modNameStyleCache = new Style[3];
    private Theme fallback;

    public ThemeHelper() {
        super(JsonConfig.GSON, "jade_themes");
    }

    public static Style colorStyle(int color) {
        return (Style)styleCache.computeIfAbsent(color, arg_0 -> ((Style)Style.EMPTY).withColor(arg_0));
    }

    @Override
    public Theme theme() {
        return (Theme)theme.getValue();
    }

    @Override
    public Collection<Theme> getThemes() {
        return this.themes.values();
    }

    @Override
    @NotNull
    public Theme getTheme(ResourceLocation id) {
        return Objects.requireNonNull(this.themes.getOrDefault(id, this.fallback));
    }

    @Override
    public MutableComponent info(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().info());
    }

    @Override
    public MutableComponent success(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().success());
    }

    @Override
    public MutableComponent warning(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().warning());
    }

    @Override
    public MutableComponent danger(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().danger());
    }

    @Override
    public MutableComponent failure(Object componentOrString) {
        return this.color(componentOrString, this.theme().text.colors().failure());
    }

    @Override
    public MutableComponent title(Object componentOrString) {
        MutableComponent component = componentOrString instanceof MutableComponent ? (MutableComponent)componentOrString : Component.literal((String)Objects.toString(componentOrString));
        return this.color(DisplayHelper.INSTANCE.stripColor((Component)component), this.theme().text.colors().title());
    }

    @Override
    public MutableComponent modName(Object componentOrString) {
        MutableComponent component = componentOrString instanceof MutableComponent ? (MutableComponent)componentOrString : Component.literal((String)Objects.toString(componentOrString));
        Style itemStyle = IWailaConfig.get().getFormatting().getItemModNameStyle();
        Style themeStyle = this.theme().text.modNameStyle();
        if (this.modNameStyleCache[0] != itemStyle || this.modNameStyleCache[1] != themeStyle) {
            Style style = itemStyle;
            if (themeStyle != null) {
                style = themeStyle.applyTo(style);
            }
            this.modNameStyleCache[0] = itemStyle;
            this.modNameStyleCache[1] = themeStyle;
            this.modNameStyleCache[2] = style;
        }
        return component.withStyle(this.modNameStyleCache[2]);
    }

    @Override
    public MutableComponent seconds(int ticks, float tickRate) {
        if ((ticks = Mth.floor((float)((float)ticks / tickRate))) >= 60) {
            int minutes = ticks / 60;
            if ((ticks %= 60) == 0) {
                return this.info(JadeClient.format("jade.minutes", minutes));
            }
            return this.info(JadeClient.format("jade.minutes_seconds", minutes, ticks));
        }
        return this.info(JadeClient.format("jade.seconds", ticks));
    }

    protected MutableComponent color(Object componentOrString, int color) {
        if (componentOrString instanceof Number) {
            Number number = (Number)componentOrString;
            componentOrString = DisplayHelper.dfCommas.format(number.doubleValue());
        }
        if (componentOrString instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)componentOrString;
            if (component.getStyle().isEmpty()) {
                return component.setStyle(ThemeHelper.colorStyle(color));
            }
            return component.setStyle(component.getStyle().withColor(color));
        }
        return Component.literal((String)Objects.toString(componentOrString)).setStyle(ThemeHelper.colorStyle(color));
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Set<ResourceLocation> existingKeys = Set.copyOf(this.themes.keySet());
        MutableObject enable = new MutableObject();
        WailaConfig.ConfigOverlay config = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigHistory history = Jade.CONFIG.get().getHistory();
        this.themes.clear();
        map.forEach((id, json) -> {
            JsonObject o = json.getAsJsonObject();
            int version = GsonHelper.getAsInt((JsonObject)o, (String)"version", (int)0);
            if (!this.allowedVersions.matches(version)) {
                Jade.LOGGER.warn("Theme {} has unsupported version {}. Skipping.", id, (Object)version);
                return;
            }
            try {
                JadeCodecs.THEME.parse((DynamicOps)JsonOps.INSTANCE, (Object)o).resultOrPartial(arg_0 -> ((Logger)Jade.LOGGER).error(arg_0)).ifPresent(theme -> {
                    theme.id = id;
                    this.themes.put((ResourceLocation)id, (Theme)theme);
                    if (enable.getValue() == null && GsonHelper.getAsBoolean((JsonObject)o, (String)"autoEnable", (boolean)false) && !existingKeys.contains(id)) {
                        enable.setValue(theme);
                    }
                });
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to load theme {}", id, (Object)e);
            }
        });
        this.fallback = this.themes.get(Theme.DEFAULT_THEME_ID);
        if (this.fallback == null) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)new NullPointerException(), (String)"Missing default theme");
            throw new ReportedException(crashreport);
        }
        int hash = 0;
        for (ResourceLocation id2 : this.themes.keySet()) {
            hash = 31 * hash + id2.hashCode();
        }
        if (hash != history.themesHash) {
            if (hash != 0 && enable.getValue() != null) {
                Theme theme = (Theme)enable.getValue();
                config.activeTheme = theme.id;
                Jade.LOGGER.info("Auto enabled theme {}", (Object)theme.id);
                if (theme.changeRoundCorner != null) {
                    config.setSquare(theme.changeRoundCorner);
                }
                if (theme.changeOpacity != 0.0f) {
                    config.setAlpha(theme.changeOpacity);
                }
            }
            history.themesHash = hash;
            Jade.CONFIG.save();
        }
        config.applyTheme(config.activeTheme);
        theme.setValue((Object)config.getTheme());
    }
}

