/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.inventory.InventoryUpdateEvent;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public class PacketHandlerMixin {
    @Shadow
    public ServerPlayer player;

    @Inject(method={"handleSetCarriedItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Inventory;selected:I", ordinal=1)})
    private void onHandleSetCarriedItem(ServerboundSetCarriedItemPacket packet, CallbackInfo ci) {
        ItemStack newMainHand;
        ItemStack oldMainHand;
        int oldSlot = this.player.getInventory().selected;
        int newSlot = packet.getSlot();
        if (oldSlot != newSlot && newSlot >= 0 && newSlot < 9 && !ItemStack.matches((ItemStack)(oldMainHand = this.player.getInventory().getItem(oldSlot)), (ItemStack)(newMainHand = this.player.getInventory().getItem(newSlot)))) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Hands((Player)this.player, EquipmentSlot.MAINHAND, 0, oldMainHand, newMainHand));
        }
    }
}

