/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.inventory.InventoryUpdateEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player player;

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void onSetItem(int index, ItemStack stack, CallbackInfo ci) {
        Inventory self = (Inventory)this;
        ItemStack oldStack = self.getItem(index);
        if (ItemStack.matches((ItemStack)oldStack, (ItemStack)stack)) {
            return;
        }
        if (this.player.level().isClientSide) {
            return;
        }
        if (index >= 0 && index < 9) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Hotbar(this.player, index, oldStack, stack));
        } else if (index >= 9 && index < 36) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.MainInventory(this.player, index, oldStack, stack));
        } else if (index == 40) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Offhand(this.player, index, oldStack, stack));
        } else if (index >= 36 && index < 40) {
            EquipmentSlot slot;
            switch (index) {
                case 36: {
                    EquipmentSlot equipmentSlot = EquipmentSlot.FEET;
                    break;
                }
                case 37: {
                    EquipmentSlot equipmentSlot = EquipmentSlot.LEGS;
                    break;
                }
                case 38: {
                    EquipmentSlot equipmentSlot = EquipmentSlot.CHEST;
                    break;
                }
                case 39: {
                    EquipmentSlot equipmentSlot = EquipmentSlot.HEAD;
                    break;
                }
                default: {
                    EquipmentSlot equipmentSlot = slot = null;
                }
            }
            if (slot != null) {
                NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Armor(this.player, slot, index, oldStack, stack));
            }
        }
        NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.All(this.player, index, oldStack, stack));
    }
}

