/*
 * Decompiled with CFR 0.152.
 */
package com.wintercogs.appliedpneumatics.common.blocks.entitis;

import appeng.api.AECapabilities;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import appeng.core.definitions.AEItems;
import com.wintercogs.appliedpneumatics.common.init.APBlockEntities;
import com.wintercogs.appliedpneumatics.common.init.APBlockStates;
import com.wintercogs.appliedpneumatics.common.init.APBlocks;
import com.wintercogs.appliedpneumatics.common.init.APItems;
import com.wintercogs.appliedpneumatics.common.me.keys.AirKey;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public class METemperatureInterfaceBlockEntity
extends AENetworkedBlockEntity
implements IUpgradeableObject,
ServerTickingBlockEntity {
    private static final int SOFT_FLAGS = 18;
    private final IUpgradeInventory upgrades = UpgradeInventories.forMachine(APBlocks.ME_TEMPERATURE_INTERFACE, (int)5, this::onUpgradesChanged);
    private static final int BASE_HEAT_CAP = 1000;
    private static final int AIR_COST_PER_1000J = 19145;
    private static final int AE_ENERGY_COST_PER_1000J = 24889;
    private double expectedTemperature = 300.0;
    private final IHeatExchangerLogic heatHandler = HeatExchangerManager.getInstance().makeHeatExchangerLogic();
    private int maxTemperatureChangePerTick = 1;
    private double lastTemperature = 0.0;

    public METemperatureInterfaceBlockEntity(BlockPos pos, BlockState blockState) {
        super(APBlockEntities.ME_TEMPERATURE_INTERFACE_BLOCK_ENTITY.get(), pos, blockState);
        this.getMainNode().setIdlePowerUsage(8.0).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setExposedOnSides(EnumSet.allOf(Direction.class));
    }

    public static void onRegisterCaps(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, APBlockEntities.ME_TEMPERATURE_INTERFACE_BLOCK_ENTITY.get(), (be, unused) -> be);
        event.registerBlockEntity(PNCCapabilities.HEAT_EXCHANGER_BLOCK, APBlockEntities.ME_TEMPERATURE_INTERFACE_BLOCK_ENTITY.get(), (be, direction) -> be.heatHandler);
    }

    public IHeatExchangerLogic getHeatHandler() {
        return this.heatHandler;
    }

    public double getExpectedTemperature() {
        return this.expectedTemperature;
    }

    public void setExpectedTemperature(double expectedTemperature) {
        this.expectedTemperature = Math.min(2273.0, Math.max(0.0, expectedTemperature));
    }

    @Nullable
    public MEStorage getNetworkInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return null;
        }
        IStorageService ss = grid.getStorageService();
        return ss != null ? ss.getInventory() : null;
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public void serverTick() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        if (this.getMainNode().isActive()) {
            this.interactWithME();
        }
        this.heatHandler.tick();
        if (this.lastTemperature != this.heatHandler.getTemperature()) {
            this.lastTemperature = this.heatHandler.getTemperature();
            this.setChanged();
            BlockState state = this.getBlockState();
            if (this.lastTemperature > 473.0) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue(APBlockStates.TEMP_STATE, (Comparable)((Object)APBlockStates.TemperatureState.HIGH_TEMPERATURE)), 18);
            } else if (this.lastTemperature < 173.0) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue(APBlockStates.TEMP_STATE, (Comparable)((Object)APBlockStates.TemperatureState.LOW_TEMPERATURE)), 18);
            } else {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue(APBlockStates.TEMP_STATE, (Comparable)((Object)APBlockStates.TemperatureState.ROOM_TEMPERATURE)), 18);
            }
        }
    }

    private void interactWithME() {
        double energyExtracted;
        double qByAE;
        double energyAvailable;
        double qMaxByAE;
        MEStorage storage = this.getNetworkInventory();
        if (storage == null) {
            return;
        }
        double currentTemperature = this.heatHandler.getTemperature();
        if (this.expectedTemperature == currentTemperature) {
            return;
        }
        double diff = this.expectedTemperature - currentTemperature;
        double sign = Math.signum(diff);
        double deltaWantedTemperature = Math.min(Math.abs(diff), (double)this.maxTemperatureChangePerTick);
        double capacity = Math.max(0.0, this.heatHandler.getThermalCapacity());
        if (capacity < 0.1) {
            return;
        }
        double qWanted = deltaWantedTemperature * capacity;
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        IEnergyService energyService = grid.getEnergyService();
        if (energyService == null) {
            return;
        }
        IActionSource actionSrc = IActionSource.ofMachine((IActionHost)this);
        long airAvailable = storage.extract((AEKey)AirKey.INSTANCE, Long.MAX_VALUE, Actionable.SIMULATE, actionSrc);
        double qMaxByAir = airAvailable <= 0L ? 0.0 : (double)airAvailable * 1000.0 / 19145.0;
        double qApply = Math.min(qWanted, Math.min(qMaxByAir, qMaxByAE = (energyAvailable = energyService.getStoredPower()) <= 0.0 ? 0.0 : energyAvailable * 1000.0 / 24889.0));
        if (qApply <= 0.0) {
            return;
        }
        long airToUse = (long)Math.min((double)airAvailable, Math.ceil(qApply / 1000.0 * 19145.0));
        double energyToUse = Math.min(energyAvailable, qApply / 1000.0 * 24889.0);
        long airExtracted = storage.extract((AEKey)AirKey.INSTANCE, airToUse, Actionable.MODULATE, actionSrc);
        double qByAir = airExtracted <= 0L ? 0.0 : (double)airExtracted * 1000.0 / 19145.0;
        double qReal = Math.min(qApply, Math.min(qByAir, qByAE = (energyExtracted = energyService.extractAEPower(energyToUse, Actionable.MODULATE, PowerMultiplier.CONFIG)) <= 0.0 ? 0.0 : energyExtracted * 1000.0 / 24889.0));
        if (qReal <= 0.0) {
            return;
        }
        this.heatHandler.addHeat(sign * qReal);
    }

    public void loadTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadTag(tag, registries);
        this.upgrades.readFromNBT(tag, "upgrades", registries);
        this.heatHandler.deserializeNBT(tag.getCompound("heat_handler"));
        this.expectedTemperature = tag.getDouble("expected_temperature");
    }

    public void onLoad() {
        super.onLoad();
        this.onUpgradesChanged();
        this.heatHandler.initializeAsHull(this.level, this.worldPosition, IHeatExchangerLogic.ALL_BLOCKS, Direction.values());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.upgrades.writeToNBT(tag, "upgrades", registries);
        tag.put("heat_handler", (Tag)this.heatHandler.serializeNBT());
        tag.putDouble("expected_temperature", this.expectedTemperature);
    }

    private void onUpgradesChanged() {
        int speedCards = this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        this.maxTemperatureChangePerTick = speedCards <= 0 ? 1 : 1 << speedCards;
        int volume_cards = this.upgrades.getInstalledUpgrades(APItems.VOLUME_CARD);
        int mul = volume_cards <= 0 ? 1 : 1 << volume_cards;
        this.heatHandler.setThermalCapacity(1000.0 * (double)mul);
        this.interactWithME();
        this.setChanged();
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (int i = 0; i < this.upgrades.size(); ++i) {
            ItemStack slotContent = this.upgrades.getStackInSlot(i);
            if (slotContent.isEmpty()) continue;
            drops.add(slotContent.copy());
        }
    }
}

