/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.DynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IDynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class BarrelBlockEntity
extends WoodStorageBlockEntity
implements IMaterialHolder {
    public static final String MATERIALS_TAG = "materials";
    public static final String STORAGE_TYPE = "barrel";
    private Map<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
    private final SophisticatedOpenersCounter openersCounter = new SophisticatedOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_OPEN);
            BarrelBlockEntity.this.updateOpenBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_CLOSE);
            BarrelBlockEntity.this.updateOpenBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousOpenerCount, int newOpenerCount) {
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)abstractContainerMenu;
                return storageContainerMenu.getStorageBlockEntity() == BarrelBlockEntity.this;
            }
            return false;
        }
    };
    private IDynamicRenderTracker dynamicRenderTracker = IDynamicRenderTracker.NOOP;

    @Override
    public SophisticatedOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    protected BarrelBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends BarrelBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
        this.getStorageWrapper().getRenderInfo().setDisplayItemsChangeListener(ri -> {
            this.dynamicRenderTracker.onRenderInfoUpdated((RenderInfo)ri);
            this.setUpdateBlockRender();
            WorldHelper.notifyBlockUpdate((BlockEntity)this);
        });
    }

    public void setDynamicRenderTracker(IDynamicRenderTracker dynamicRenderTracker) {
        this.dynamicRenderTracker = dynamicRenderTracker;
    }

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, (BlockEntityType<? extends BarrelBlockEntity>)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get());
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
        CompoundTag tag = pkt.getTag();
        if (tag.getBoolean("updateBlockRender")) {
            this.dynamicRenderTracker.onRenderInfoUpdated(this.getStorageWrapper().getRenderInfo());
        }
    }

    void updateOpenBlockState(BlockState state, boolean open) {
        if (this.level == null) {
            return;
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (level.isClientSide && this.dynamicRenderTracker == IDynamicRenderTracker.NOOP) {
            this.dynamicRenderTracker = new DynamicRenderTracker(this);
        }
    }

    public boolean hasDynamicRenderer() {
        return this.dynamicRenderTracker.isDynamicRenderer();
    }

    public boolean hasFullyDynamicRenderer() {
        return this.dynamicRenderTracker.isFullyDynamicRenderer();
    }

    @Override
    public void toggleLock() {
        this.setUpdateBlockRender();
        super.toggleLock();
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        NBTHelper.putMap((CompoundTag)tag, (String)MATERIALS_TAG, this.materials, BarrelMaterial::getSerializedName, resourceLocation -> StringTag.valueOf((String)resourceLocation.toString()));
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadSynchronizedData(tag, registries);
        this.materials = NBTHelper.getMap((CompoundTag)tag, (String)MATERIALS_TAG, BarrelMaterial::fromName, (bm, t) -> Optional.of(ResourceLocation.parse((String)t.getAsString()))).orElse(Map.of());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (this.level != null && this.level.isClientSide() && tag.getBoolean("updateBlockRender")) {
            this.dynamicRenderTracker.onRenderInfoUpdated(this.getStorageWrapper().getRenderInfo());
        }
    }

    @Override
    public void setMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        this.materials = materials;
        this.setChanged();
    }

    @Override
    public Map<BarrelMaterial, ResourceLocation> getMaterials() {
        return this.materials;
    }

    @Override
    public boolean canHoldMaterials() {
        return true;
    }
}

