/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.processing;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.entity.processing.RefineryModuleBlockEntity;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class RefineryModuleBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public RefineryModuleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, MultiblockMachine.ASSEMBLED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            Boolean corePlaced;
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof MultiblockMachineController)) {
                return InteractionResult.SUCCESS;
            }
            MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
            Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = machineEntity.tryPlaceNextCore(player)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            boolean isAssembled = machineEntity.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                machineEntity.triggerSetupAnimation();
                return InteractionResult.SUCCESS;
            }
            if (!isAssembled) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (ItemFluidApi.tryFluidBlockItemInteraction(stack, world, pos, player, hand)) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity entity;
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue() && (entity = world.getBlockEntity(pos)) instanceof MultiblockMachineController) {
            MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
            machineEntity.onControllerBroken();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RefineryModuleBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        tooltip.add((Component)Component.translatable((String)"tooltip.oritech.refinery_module").withStyle(ChatFormatting.GRAY));
        TooltipHelper.addMachineTooltip(tooltip, (Block)this, this);
    }
}

