/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.item.containers;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class SimpleInventoryStorage
implements Container,
ItemApi.InventoryStorage,
UpdatableField<Void, List<ItemStack>> {
    private final int size;
    public final NonNullList<ItemStack> heldStacks;
    private final Runnable onUpdate;

    public SimpleInventoryStorage(int size, Runnable onUpdate) {
        this.size = size;
        this.onUpdate = onUpdate;
        this.heldStacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    @Override
    public int insert(ItemStack toInsert, boolean simulate) {
        int remaining = toInsert.getCount();
        for (int slot = 0; slot < this.getContainerSize() && remaining > 0; remaining -= this.insertToSlot(toInsert.copyWithCount(remaining), slot, simulate), ++slot) {
        }
        return toInsert.getCount() - remaining;
    }

    @Override
    public int insertToSlot(ItemStack addedStack, int slot, boolean simulate) {
        int available;
        int toInsert;
        ItemStack slotStack = this.getItem(slot);
        int slotLimit = Math.min(this.getSlotLimit(slot), addedStack.getMaxStackSize());
        if (slotStack.isEmpty()) {
            int toInsert2 = Math.min(slotLimit, addedStack.getCount());
            if (!simulate) {
                this.setItem(slot, addedStack.copyWithCount(toInsert2));
            }
            return toInsert2;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)addedStack) && (toInsert = Math.min(available = slotLimit - slotStack.getCount(), addedStack.getCount())) > 0) {
            if (!simulate) {
                slotStack.grow(toInsert);
            }
            return toInsert;
        }
        return 0;
    }

    @Override
    public int extract(ItemStack toExtract, boolean simulate) {
        int remaining = toExtract.getCount();
        for (int slot = 0; slot < this.getContainerSize() && remaining > 0; remaining -= this.extractFromSlot(toExtract.copyWithCount(remaining), slot, simulate), ++slot) {
        }
        return toExtract.getCount() - remaining;
    }

    @Override
    public int extractFromSlot(ItemStack extracted, int slot, boolean simulate) {
        ItemStack slotStack = this.getItem(slot);
        if (slotStack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)extracted)) {
            return 0;
        }
        int toExtract = Math.min(slotStack.getCount(), extracted.getCount());
        if (!simulate) {
            slotStack.shrink(toExtract);
        }
        return toExtract;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.setItem(slot, stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.getItem(slot);
    }

    @Override
    public int getSlotCount() {
        return this.getContainerSize();
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.heldStacks) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.heldStacks.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.heldStacks, (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = (ItemStack)this.heldStacks.get(slot);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.heldStacks.set(slot, (Object)ItemStack.EMPTY);
        return itemStack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.heldStacks.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public void setChanged() {
        this.update();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.heldStacks.clear();
        this.setChanged();
    }

    public NonNullList<ItemStack> getHeldStacks() {
        return this.heldStacks;
    }

    @Override
    public List<ItemStack> getDeltaData() {
        return this.heldStacks;
    }

    @Override
    public Void getFullData() {
        return null;
    }

    @Override
    public StreamCodec<? extends ByteBuf, List<ItemStack>> getDeltaCodec() {
        return ItemStack.OPTIONAL_LIST_STREAM_CODEC;
    }

    @Override
    public StreamCodec<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }

    @Override
    public void handleFullUpdate(Void updatedData) {
    }

    @Override
    public void handleDeltaUpdate(List<ItemStack> updatedData) {
        this.heldStacks.clear();
        for (int i = 0; i < updatedData.size(); ++i) {
            ItemStack added = updatedData.get(i);
            this.heldStacks.set(i, (Object)added);
        }
    }
}

