/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.Collections;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.block.BlockPersonalStorage;
import mekanism.common.inventory.container.item.PersonalStorageItemContainer;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IDroppableContents;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.lib.inventory.personalstorage.AbstractPersonalStorageItemInventory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.lib.security.ItemSecurityUtils;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemBlockPersonalStorage<BLOCK extends BlockPersonalStorage<?, ?>>
extends ItemBlockTooltip<BLOCK>
implements IDroppableContents,
IGuiItem {
    private final ResourceLocation openStat;

    public ItemBlockPersonalStorage(BLOCK block, Item.Properties properties, ResourceLocation openStat) {
        super(block, true, properties);
        this.openStat = openStat;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return ItemSecurityUtils.get().claimOrOpenGui(world, player, hand, (p, h, s) -> {
            if (!world.isClientSide) {
                PersonalStorageManager.getInventoryFor(s);
            }
            this.getContainerType().tryOpenGui((ServerPlayer)p, (InteractionHand)h, (ItemStack)s);
            p.awardStat(Stats.CUSTOM.get((Object)this.openStat));
        });
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        InteractionResult result = this.place(new BlockPlaceContext(context));
        Player player = context.getPlayer();
        return result.consumesAction() || player == null ? result : this.use(context.getLevel(), player, context.getHand()).getResult();
    }

    protected boolean canPlace(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Player player = context.getPlayer();
        return (player == null || player.isFakePlayer() || player.isShiftKeyDown()) && super.canPlace(context, state);
    }

    public ContainerTypeRegistryObject<PersonalStorageItemContainer> getContainerType() {
        return MekanismContainerTypes.PERSONAL_STORAGE_ITEM;
    }

    @Override
    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        ItemStack stack;
        AbstractPersonalStorageItemInventory inventory;
        super.onDestroyed(item, damageSource);
        if (!item.level().isClientSide && (inventory = (AbstractPersonalStorageItemInventory)PersonalStorageManager.getInventoryIfPresent(stack = item.getItem()).orElse(null)) != null && inventory.isInventoryEmpty()) {
            PersonalStorageManager.deleteInventory(stack);
        }
    }

    @Override
    public List<IInventorySlot> getDroppedSlots(ItemStack stack) {
        return PersonalStorageManager.getInventoryIfPresent(stack).map(inventory -> inventory.getInventorySlots(null)).orElse(Collections.emptyList());
    }

    @Override
    public int getScalar(ItemStack stack) {
        return 1;
    }
}

