/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicChemicalInfuserRecipe;
import mekanism.api.recipes.basic.BasicPigmentMixingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.BiChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical")
public abstract class ChemicalChemicalToChemicalRecipeManager
extends MekanismRecipeManager<BiChemicalRecipeInput, ChemicalChemicalToChemicalRecipe> {
    protected ChemicalChemicalToChemicalRecipeManager(IMekanismRecipeTypeProvider<BiChemicalRecipeInput, ChemicalChemicalToChemicalRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ICrTChemicalStack output) {
        this.addRecipe(name, this.makeRecipe(leftInput, rightInput, output));
    }

    public final ChemicalChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ICrTChemicalStack output) {
        return this.makeRecipe(leftInput, rightInput, this.getAndValidateNotEmpty(output));
    }

    protected abstract ChemicalChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient var1, ChemicalStackIngredient var2, ChemicalStack var3);

    @Override
    protected String describeOutputs(ChemicalChemicalToChemicalRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical.PigmentMixing")
    public static class PigmentMixingRecipeManager
    extends ChemicalChemicalToChemicalRecipeManager {
        public static final PigmentMixingRecipeManager INSTANCE = new PigmentMixingRecipeManager();

        private PigmentMixingRecipeManager() {
            super((IMekanismRecipeTypeProvider<BiChemicalRecipeInput, ChemicalChemicalToChemicalRecipe, ?>)MekanismRecipeType.PIGMENT_MIXING);
        }

        @Override
        protected ChemicalChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient left, ChemicalStackIngredient right, ChemicalStack output) {
            return new BasicPigmentMixingRecipe(left, right, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalChemicalToChemical.ChemicalInfusing")
    public static class ChemicalInfuserRecipeManager
    extends ChemicalChemicalToChemicalRecipeManager {
        public static final ChemicalInfuserRecipeManager INSTANCE = new ChemicalInfuserRecipeManager();

        private ChemicalInfuserRecipeManager() {
            super((IMekanismRecipeTypeProvider<BiChemicalRecipeInput, ChemicalChemicalToChemicalRecipe, ?>)MekanismRecipeType.CHEMICAL_INFUSING);
        }

        @Override
        protected ChemicalChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient left, ChemicalStackIngredient right, ChemicalStack output) {
            return new BasicChemicalInfuserRecipe(left, right, output);
        }
    }
}

