/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

@NothingNullByDefault
public record FilterAware(List<IFilter<?>> filters) {
    public static final FilterAware EMPTY = new FilterAware(Collections.emptyList());
    public static final Codec<FilterAware> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BaseFilter.GENERIC_CODEC.listOf().promotePartial(error -> Mekanism.logger.error("Failed to load filters: {}", error)).fieldOf("filters").forGetter(FilterAware::filters)).apply((Applicative)instance, FilterAware::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FilterAware> STREAM_CODEC = BaseFilter.GENERIC_STREAM_CODEC.apply(ByteBufCodecs.list()).map(FilterAware::new, FilterAware::filters);

    public FilterAware {
        filters = List.copyOf(filters);
    }

    private <FILTER extends IFilter<?>> Stream<FILTER> getEnabledStream(Class<FILTER> filterClass) {
        return this.filters.stream().filter(IFilter::isEnabled).filter(filterClass::isInstance).map(filterClass::cast);
    }

    public <FILTER extends IFilter<?>> List<FILTER> getEnabled(Class<FILTER> filterClass) {
        return this.getEnabledStream(filterClass).toList();
    }

    public <FILTER extends IFilter<?>> boolean anyEnabledMatch(Class<FILTER> filterClass, Predicate<FILTER> validator) {
        return this.getEnabledStream(filterClass).anyMatch(validator);
    }
}

