/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.element.window.filter.GuiFilterHelper;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.filter.PacketEditFilter;
import mekanism.common.network.to_server.filter.PacketNewFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiFilter<FILTER extends IFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiWindow
implements GuiFilterHelper<TILE> {
    public static final Predicate<ItemStack> NOT_EMPTY = stack -> !stack.isEmpty();
    public static final Predicate<ItemStack> NOT_EMPTY_BLOCK = stack -> !stack.isEmpty() && stack.getItem() instanceof BlockItem;
    private final Component filterName;
    @Nullable
    protected final FILTER origFilter;
    protected final FILTER filter;
    protected final TILE tile;
    private final boolean isNew;
    protected Component status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN);
    protected GuiSequencedSlotDisplay slotDisplay;
    private int ticker;

    protected GuiFilter(IGuiWrapper gui, int x, int y, int width, int height, Component filterName, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, SelectedWindowData.UNSPECIFIED);
        this.tile = tile;
        this.origFilter = origFilter;
        this.filterName = filterName;
        if (origFilter == null) {
            this.isNew = true;
            this.filter = this.createNewFilter();
        } else {
            this.isNew = false;
            this.filter = origFilter.clone();
        }
        this.init();
        if (!this.isFocusOverlay()) {
            if (this.isNew && this.hasFilterSelect()) {
                this.addChild(new MekanismImageButton(gui, this.relativeX + 6, this.relativeY + 6, 11, 14, GuiFilter.getButtonLocation("back"), (element, mouseX, mouseY) -> {
                    IGuiWrapper wrapper = element.gui();
                    wrapper.addWindow(this.getFilterSelect(wrapper, (TileEntityMekanism)this.tile));
                    return this.close(element, mouseX, mouseY);
                })).setTooltip(TooltipUtils.BACK);
            } else {
                super.addCloseButton();
            }
        }
        if (this.filter.hasFilter()) {
            this.slotDisplay.updateStackList();
        }
    }

    @Override
    protected int getTitlePadStart() {
        if (this.isNew && this.hasFilterSelect()) {
            return super.getTitlePadStart() + 3;
        }
        return super.getTitlePadStart();
    }

    @Override
    protected void addCloseButton() {
    }

    public FILTER getFilter() {
        return this.filter;
    }

    protected int getSlotOffset() {
        return 18;
    }

    protected int getScreenHeight() {
        return 42;
    }

    @Override
    public int getScreenWidth() {
        return 116;
    }

    protected int getLeftButtonX() {
        return this.relativeX + this.width / 2 - 61;
    }

    protected void init() {
        int screenTop = this.relativeY + 18;
        int screenBottom = screenTop + this.getScreenHeight();
        this.addChild(new GuiInnerScreen(this.gui(), this.relativeX + 29, screenTop, this.getScreenWidth(), this.getScreenHeight(), this::getScreenText).clearFormat());
        this.addChild(new TranslationButton(this.gui(), this.getLeftButtonX(), screenBottom + 2, 60, 20, this.isNew ? MekanismLang.BUTTON_CANCEL : MekanismLang.BUTTON_DELETE, (element, mouseX, mouseY) -> {
            if (this.origFilter != null) {
                PacketUtils.sendToServer(new PacketEditFilter<Object>(this.tile.getBlockPos(), this.origFilter, null));
            }
            return this.close(element, mouseX, mouseY);
        }));
        this.addChild(new TranslationButton(this.gui(), this.getLeftButtonX() + 62, screenBottom + 2, 60, 20, MekanismLang.BUTTON_SAVE, (element, mouseX, mouseY) -> {
            this.validateAndSave();
            return true;
        }));
        GuiSlot slot = this.addChild(new GuiSlot(SlotType.NORMAL, this.gui(), this.relativeX + 7, this.relativeY + this.getSlotOffset()).setRenderHover(true).setGhostHandler(this.getGhostHandler()));
        GuiElement.IClickable slotClickHandler = this.getSlotClickHandler();
        if (slotClickHandler != null) {
            slot.click(slotClickHandler);
        }
        this.slotDisplay = this.addChild(new GuiSequencedSlotDisplay(this.gui(), this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, this::getRenderStacks));
    }

    @Nullable
    protected GuiElement.IClickable getSlotClickHandler() {
        return null;
    }

    @Nullable
    protected IRecipeViewerGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return null;
    }

    protected List<Component> getScreenText() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)MekanismLang.STATUS.translate(this.status));
        return list;
    }

    protected void validateAndSave() {
        if (this.filter.hasFilter()) {
            this.saveFilter();
        } else {
            this.filterSaveFailed(this.getNoFilterSaveError(), new Object[0]);
        }
    }

    protected static <FILTER extends SorterFilter<FILTER>> void validateAndSaveSorterFilter(GuiFilter<FILTER, ?> guiFilter, GuiTextField minField, GuiTextField maxField) {
        if (((SorterFilter)guiFilter.filter).hasFilter()) {
            if (minField.getText().isEmpty() || maxField.getText().isEmpty()) {
                guiFilter.filterSaveFailed(MekanismLang.SORTER_FILTER_SIZE_MISSING, new Object[0]);
            } else {
                int min = Integer.parseInt(minField.getText());
                int max = Integer.parseInt(maxField.getText());
                if (max >= min && max <= 99) {
                    ((SorterFilter)guiFilter.filter).min = min;
                    ((SorterFilter)guiFilter.filter).max = max;
                    guiFilter.saveFilter();
                } else if (min > max) {
                    guiFilter.filterSaveFailed(MekanismLang.SORTER_FILTER_MAX_LESS_THAN_MIN, new Object[0]);
                } else {
                    guiFilter.filterSaveFailed(MekanismLang.SORTER_FILTER_OVER_SIZED, 99);
                }
            }
        } else {
            guiFilter.filterSaveFailed(guiFilter.getNoFilterSaveError(), new Object[0]);
        }
    }

    protected void filterSaveFailed(ILangEntry reason, Object ... args) {
        this.status = reason.translateColored(EnumColor.DARK_RED, args);
        this.ticker = 100;
    }

    protected void filterSaveSuccess() {
        this.status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN);
        this.ticker = 0;
    }

    protected void saveFilter() {
        if (this.isNew) {
            PacketUtils.sendToServer(new PacketNewFilter(this.tile.getBlockPos(), (IFilter<?>)this.filter));
        } else {
            PacketUtils.sendToServer(new PacketEditFilter<FILTER>(this.tile.getBlockPos(), this.origFilter, this.filter));
        }
        this.close();
    }

    protected abstract ILangEntry getNoFilterSaveError();

    @NotNull
    protected abstract List<ItemStack> getRenderStacks();

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)(this.isNew ? MekanismLang.FILTER_NEW : MekanismLang.FILTER_EDIT).translate(this.filterName), 6);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            this.status = MekanismLang.STATUS_OK.translateColored(EnumColor.DARK_GREEN);
        }
    }

    protected abstract FILTER createNewFilter();

    public static GuiElement.IClickable getHandleClickSlot(Predicate<ItemStack> stackValidator, Consumer<ItemStack> itemConsumer) {
        return (element, mouseX, mouseY) -> {
            if (Screen.hasShiftDown()) {
                itemConsumer.accept(ItemStack.EMPTY);
            } else {
                ItemStack stack = element.gui().getCarriedItem();
                if (!stackValidator.test(stack)) {
                    return false;
                }
                itemConsumer.accept(stack.copyWithCount(1));
            }
            return true;
        };
    }
}

