/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiInstallableScrollList;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuiUpgradeScrollList
extends GuiInstallableScrollList<Upgrade> {
    private static final ResourceLocation UPGRADE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "upgrade_selection.png");
    private final Map<Upgrade, Tooltip> tooltips = new EnumMap<Upgrade, Tooltip>(Upgrade.class);
    private final TileComponentUpgrade component;
    private final Runnable onSelectionChange;

    public GuiUpgradeScrollList(IGuiWrapper gui, int x, int y, int height, TileComponentUpgrade component, Runnable onSelectionChange) {
        super(gui, x, y, height, GuiElementHolder.HOLDER, 32, UPGRADE_SELECTION, 100, 36);
        this.component = component;
        this.onSelectionChange = onSelectionChange;
    }

    @Override
    protected int getMaxElements() {
        return this.component.getInstalledTypes().size();
    }

    @Override
    protected void setSelected(Upgrade newSelection) {
        if (this.selectedType != newSelection) {
            this.selectedType = newSelection;
            this.onSelectionChange.run();
        }
    }

    @Override
    protected List<Upgrade> getCurrentInstalled() {
        return new ArrayList<Upgrade>(this.component.getInstalledTypes());
    }

    @Override
    protected void drawName(GuiGraphics guiGraphics, Upgrade upgrade, int y) {
        this.drawNameText(guiGraphics, y, upgrade.getTranslatedName(), this.titleTextColor(), 1.0f);
    }

    @Override
    protected ItemStack getRenderStack(Upgrade upgrade) {
        return UpgradeUtils.getStack(upgrade);
    }

    @Override
    @Nullable
    protected EnumColor getColor(Upgrade upgrade) {
        return upgrade.getColor();
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1) {
            int index;
            List<Upgrade> currentInstalled = this.getCurrentInstalled();
            int currentSelection = this.getCurrentSelection();
            int focused = this.getFocusedElements();
            for (int i = 0; i < focused && (index = currentSelection + i) <= currentInstalled.size() - 1; ++i) {
                Upgrade upgrade = currentInstalled.get(index);
                int multipliedElement = this.elementHeight * i;
                if (mouseY < this.getY() + 1 + multipliedElement || mouseY >= this.getY() + 1 + multipliedElement + this.elementHeight) continue;
                this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1, this.getY() + 1 + multipliedElement, this.barXShift - 2, this.elementHeight);
                this.setTooltip(this.tooltips.computeIfAbsent(upgrade, u -> TooltipUtils.create(u.getDescription())));
                return;
            }
        }
        this.cachedTooltipRect = null;
        this.clearTooltip();
    }

    @Override
    public void renderElements(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hasSelection() && this.component.getUpgrades((Upgrade)this.getSelection()) == 0) {
            this.clearSelection();
        }
        super.renderElements(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiUpgradeScrollList old = (GuiUpgradeScrollList)element;
        this.selectedType = old.selectedType;
        this.onSelectionChange.run();
    }
}

