/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IModuleHelper {
    public static final IModuleHelper INSTANCE = MekanismAPI.getService(IModuleHelper.class);

    @Deprecated(forRemoval=true, since="10.7.11")
    default public Item createModuleItem(IModuleDataProvider<?> moduleDataProvider, Item.Properties properties) {
        return this.createModuleItem(() -> this.asHolder(moduleDataProvider), properties);
    }

    public Item createModuleItem(Supplier<Holder<ModuleData<?>>> var1, Item.Properties var2);

    public Item.Properties applyModuleContainerProperties(Item.Properties var1);

    public void dropModuleContainerContents(ItemEntity var1, DamageSource var2);

    public Set<ModuleData<?>> getSupported(Item var1);

    default public Set<ModuleData<?>> getSupported(Holder<Item> item) {
        return this.getSupported((Item)item.value());
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public Set<Item> getSupported(IModuleDataProvider<?> typeProvider) {
        return this.getSupportedItems(this.asHolder(typeProvider));
    }

    public Set<Item> getSupportedItems(Holder<ModuleData<?>> var1);

    @Deprecated(forRemoval=true, since="10.7.11")
    default public boolean supports(Item item, IModuleDataProvider<?> typeProvider) {
        return this.getSupported(item).contains(typeProvider.getModuleData());
    }

    default public boolean supports(Holder<Item> item, Holder<ModuleData<?>> type) {
        return this.getSupported(item).contains(type.value());
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public Set<ModuleData<?>> getConflicting(IModuleDataProvider<?> typeProvider) {
        return this.getConflicting(this.asHolder(typeProvider));
    }

    public Set<ModuleData<?>> getConflicting(Holder<ModuleData<?>> var1);

    @Deprecated(forRemoval=true, since="10.7.11")
    default public boolean isEnabled(ItemStack stack, IModuleDataProvider<?> typeProvider) {
        return this.isEnabled(stack, this.asHolder(typeProvider));
    }

    default public boolean isEnabled(ItemStack stack, Holder<ModuleData<?>> type) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container != null && container.hasEnabled(type);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getModule(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container == null ? null : container.get(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getModule(ItemStack stack, DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container == null ? null : container.get(type);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container == null ? null : container.getIfEnabled(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(ItemStack stack, DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container == null ? null : container.getIfEnabled(type);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainer(entity, slot);
        return container == null ? null : container.getIfEnabled(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot, DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        IModuleContainer container = this.getModuleContainer(entity, slot);
        return container == null ? null : container.getIfEnabled(type);
    }

    @Nullable
    public IModuleContainer getModuleContainer(ItemStack var1);

    @Nullable
    default public IModuleContainer getModuleContainer(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot) {
        if (entity == null || slot == null) {
            return null;
        }
        return this.getModuleContainer(entity.getItemBySlot(slot));
    }

    default public boolean isModuleContainer(ItemStack stack) {
        return !stack.isEmpty() && this.isModuleContainer((Holder<Item>)stack.getItemHolder());
    }

    public boolean isModuleContainer(Item var1);

    default public boolean isModuleContainer(Holder<Item> item) {
        return this.isModuleContainer((Item)item.value());
    }

    default public Collection<? extends IModule<?>> getAllModules(ItemStack stack) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container == null ? Collections.emptyList() : container.modules();
    }

    default public <MODULE extends ICustomModule<?>> List<? extends IModule<? extends MODULE>> getAllModules(ItemStack stack, Class<MODULE> moduleClass) {
        ArrayList list = new ArrayList();
        for (IModule<?> module : this.getAllModules(stack)) {
            if (!moduleClass.isInstance(module.getCustomInstance())) continue;
            list.add(module);
        }
        return list;
    }

    default public Set<ModuleData<?>> getAllTypes(ItemStack stack) {
        IModuleContainer container = this.getModuleContainer(stack);
        return container != null ? container.moduleTypes() : Collections.emptySet();
    }

    public IHUDElement hudElement(ResourceLocation var1, Component var2, IHUDElement.HUDColor var3);

    public IHUDElement hudElementEnabled(ResourceLocation var1, boolean var2);

    public IHUDElement hudElementPercent(ResourceLocation var1, double var2);

    public void addMekaSuitModuleModels(ResourceLocation var1);

    @Deprecated(forRemoval=true, since="10.7.11")
    default public void addMekaSuitModuleModelSpec(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType) {
        this.addMekaSuitModuleModelSpec(name, moduleDataProvider, slotType, ConstantPredicates.alwaysTrue());
    }

    default public void addMekaSuitModuleModelSpec(String name, Holder<ModuleData<?>> moduleData, EquipmentSlot slotType) {
        this.addMekaSuitModuleModelSpec(name, moduleData, slotType, ConstantPredicates.alwaysTrue());
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public void addMekaSuitModuleModelSpec(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType, Predicate<LivingEntity> isActive) {
        this.addMekaSuitModuleModelSpec(name, this.asHolder(moduleDataProvider), slotType, isActive);
    }

    public void addMekaSuitModuleModelSpec(String var1, Holder<ModuleData<?>> var2, EquipmentSlot var3, Predicate<LivingEntity> var4);

    @Deprecated(forRemoval=true, since="10.7.11")
    private Holder<ModuleData<?>> asHolder(IModuleDataProvider<?> moduleDataProvider) {
        return MekanismAPI.MODULE_REGISTRY.wrapAsHolder(moduleDataProvider.getModuleData());
    }
}

