/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.basic.BasicItemStackToEnergyRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;

@NothingNullByDefault
public class ItemStackToEnergyRecipeBuilder
extends MekanismRecipeBuilder<ItemStackToEnergyRecipeBuilder> {
    private final ItemStackIngredient input;
    private final long output;

    protected ItemStackToEnergyRecipeBuilder(ItemStackIngredient input, long output) {
        this.input = input;
        this.output = output;
    }

    public static ItemStackToEnergyRecipeBuilder energyConversion(ItemStackIngredient input, long output) {
        if (output <= 0L) {
            throw new IllegalArgumentException("This energy conversion recipe requires an energy output greater than zero");
        }
        return new ItemStackToEnergyRecipeBuilder(input, output);
    }

    protected ItemStackToEnergyRecipe asRecipe() {
        return new BasicItemStackToEnergyRecipe(this.input, this.output);
    }
}

