/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Range;

public class NormalizedTicker {
    protected long gameTime;
    protected int suppressed;
    protected final NormalizedTickFunction tick;

    protected NormalizedTicker(NormalizedTickFunction tick) {
        this.tick = tick;
    }

    public void tick(Level level) {
        if (level == null) {
            return;
        }
        ++this.suppressed;
        long gt = level.getGameTime();
        if (gt != this.gameTime) {
            this.gameTime = gt;
            this.tick.tick(this.suppressed);
            this.suppressed = 0;
        }
    }

    public boolean atTickRate(int rate) {
        return this.gameTime % (long)rate == 0L;
    }

    public static NormalizedTicker create(NormalizedTickFunction tick) {
        return new NormalizedTicker(tick);
    }

    @FunctionalInterface
    public static interface NormalizedTickFunction {
        public void tick(@Range(from=1L, to=0x7FFFFFFFL) int var1);
    }
}

