/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBUtils {
    public static boolean almostEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    public static Vec3 randomPosWithin(AABB aabb, Random rng) {
        return new Vec3(Mth.lerp((double)rng.nextDouble(), (double)aabb.minX, (double)aabb.maxX), Mth.lerp((double)rng.nextDouble(), (double)aabb.minY, (double)aabb.maxY), Mth.lerp((double)rng.nextDouble(), (double)aabb.minZ, (double)aabb.maxZ));
    }

    public static Vec3 randomPosWithin(AABB aabb, RandomSource rng) {
        return new Vec3(Mth.lerp((double)rng.nextDouble(), (double)aabb.minX, (double)aabb.maxX), Mth.lerp((double)rng.nextDouble(), (double)aabb.minY, (double)aabb.maxY), Mth.lerp((double)rng.nextDouble(), (double)aabb.minZ, (double)aabb.maxZ));
    }

    public static AABB rotate(AABB aabb, Rotation rotationIn) {
        return switch (rotationIn) {
            default -> aabb;
            case Rotation.CLOCKWISE_90 -> new AABB(-aabb.minX, aabb.minY, aabb.minZ, -aabb.maxX, aabb.maxY, aabb.maxZ);
            case Rotation.CLOCKWISE_180 -> new AABB(-aabb.minX, aabb.minY, -aabb.minZ, -aabb.maxX, aabb.maxY, -aabb.maxZ);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(aabb.minX, aabb.minY, -aabb.minZ, aabb.maxX, aabb.maxY, -aabb.maxZ);
        };
    }

    public static AABB normalize(AABB aabb) {
        return aabb.move(-aabb.minX, -aabb.minY, -aabb.minZ);
    }

    public static AABB lerp(AABB prev, AABB cur, float pv) {
        return new AABB(Mth.lerp((double)pv, (double)prev.minX, (double)cur.minX), Mth.lerp((double)pv, (double)prev.minY, (double)cur.minY), Mth.lerp((double)pv, (double)prev.minZ, (double)cur.minZ), Mth.lerp((double)pv, (double)prev.maxX, (double)cur.maxX), Mth.lerp((double)pv, (double)prev.maxY, (double)cur.maxY), Mth.lerp((double)pv, (double)prev.maxZ, (double)cur.maxZ));
    }

    public static AABB extrudeGravity(AABB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.inflate((double)(-ay) * (aabb.maxX - aabb.minX) / 2.0, (double)ay * (aabb.maxY - aabb.minY) / 2.0, (double)(-ay) * (aabb.maxZ - aabb.minZ) / 2.0).move(0.0, (double)(-ySpeed) * (aabb.maxY - aabb.minY) / 2.0, 0.0);
    }

    public static void cut(AABB box, AABB knife, List<AABB> intoList) {
        AABBUtils.cut(box, knife, intoList::add);
    }

    public static void cut(AABB box, AABB knife, Consumer<AABB> intoList) {
        boolean ea2;
        boolean ea1;
        if (!box.intersects(knife)) {
            intoList.accept(box);
            return;
        }
        AABB inter = box.intersect(knife);
        if (!AABBUtils.almostEqual(box.minY, inter.minY)) {
            intoList.accept(new AABB(box.minX, box.minY, box.minZ, box.maxX, inter.minY, box.maxZ));
        }
        if (!AABBUtils.almostEqual(box.maxY, inter.maxY)) {
            intoList.accept(new AABB(box.minX, inter.maxY, box.minZ, box.maxX, box.maxY, box.maxZ));
        }
        if (ea1 = !AABBUtils.almostEqual(box.maxX, inter.maxX)) {
            intoList.accept(new AABB(inter.maxX, inter.minY, box.minZ, box.maxX, inter.maxY, inter.maxZ));
        }
        if (ea2 = !AABBUtils.almostEqual(box.maxZ, inter.maxZ)) {
            intoList.accept(new AABB(box.minX, inter.minY, inter.maxZ, inter.maxX, inter.maxY, box.maxZ));
        }
        if (ea1 && ea2) {
            intoList.accept(new AABB(inter.maxX, inter.minY, inter.maxZ, box.maxX, inter.maxY, box.maxZ));
        }
        if (ea1 = !AABBUtils.almostEqual(box.minZ, inter.minZ)) {
            intoList.accept(new AABB(inter.minX, inter.minY, box.minZ, inter.maxX, inter.maxY, inter.minZ));
        }
        if (ea2 = !AABBUtils.almostEqual(box.minX, inter.minX)) {
            intoList.accept(new AABB(box.minX, inter.minY, inter.minZ, inter.minX, inter.maxY, inter.maxZ));
        }
        if (ea1 || ea2) {
            intoList.accept(new AABB(box.minX, inter.minY, box.minZ, inter.minX, inter.maxY, inter.minZ));
        }
    }

    @Deprecated
    public static Vec3 getCenter(AABB aabb) {
        return aabb.getCenter();
    }
}

