/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.render.item.Stack2ImageRenderer;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.mcf.Resources;

public class RenderItemsPacket
implements IPacket {
    private int mode;
    private int size;
    private String data;

    public RenderItemsPacket() {
    }

    public RenderItemsPacket(int mode, int size, String data) {
        this.mode = mode;
        this.size = size;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.mode);
        buf.writeInt(this.size);
        buf.writeUtf(this.data);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.mode = buf.readInt();
        this.size = buf.readInt();
        this.data = buf.readUtf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        switch (this.mode) {
            case 0: {
                Stack2ImageRenderer.renderItem((Component)Component.literal((String)"Main hand"), Minecraft.getInstance().player.getMainHandItem(), this.size);
                break;
            }
            case 1: {
                Stack2ImageRenderer.renderMod(this.data, this.size);
                break;
            }
            case 2: {
                Stack2ImageRenderer.renderAll(this.size);
                break;
            }
            case 3: {
                ctx.registryAccess().registry(Registries.CREATIVE_MODE_TAB).map(r -> (CreativeModeTab)r.get(Resources.location(this.data))).ifPresent(tab -> Stack2ImageRenderer.renderTab(Resources.location(this.data), tab, this.size));
            }
        }
    }
}

