/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

@EventBusSubscriber
public class ServerListener {
    public static final List<BlockEntity> NEED_SYNC = new ArrayList<BlockEntity>();
    public static final List<BlockEntity> NEED_PROP_SYNC = new ArrayList<BlockEntity>();
    public static final List<IBasePropertyHolder> NEED_PROP_SYNC_GENERIC = new ArrayList<IBasePropertyHolder>();

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post e) {
        BlockEntity tile;
        HashSet<BlockPos> processed = new HashSet<BlockPos>();
        while (!NEED_SYNC.isEmpty()) {
            tile = NEED_SYNC.remove(0);
            if (!processed.add(tile.getBlockPos())) continue;
            if (tile instanceof ISyncableTile) {
                ISyncableTile s = (ISyncableTile)tile;
                s.syncNow();
                continue;
            }
            Network.sendToTracking((IPacket)new SyncTileEntityPacket(tile, false), tile);
        }
        processed.clear();
        while (!NEED_PROP_SYNC.isEmpty()) {
            tile = NEED_PROP_SYNC.remove(0);
            if (!processed.add(tile.getBlockPos()) || !(tile instanceof IPropertyTile)) continue;
            IPropertyTile ipt = (IPropertyTile)tile;
            ipt.syncPropertiesNow();
        }
        while (!NEED_PROP_SYNC_GENERIC.isEmpty()) {
            IBasePropertyHolder data = NEED_PROP_SYNC_GENERIC.remove(0);
            if (data == null) continue;
            data.syncPropertiesNow();
        }
    }

    public static void syncProperties(IBasePropertyHolder ent) {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER) {
            NEED_PROP_SYNC_GENERIC.add(ent);
        }
    }

    public static void syncTileEntity(BlockEntity tileEntity) {
        Level level;
        if (tileEntity != null && (level = tileEntity.getLevel()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!sl.isClientSide) {
                NEED_SYNC.add(tileEntity);
            }
        }
    }
}

