/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.recipes.replacers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import org.zeith.hammerlib.core.RegistriesHL;

@FunctionalInterface
public interface IRemainingItemReplacer {
    public ItemStack replace(CraftingInput var1, int var2, ItemStack var3);

    public static void toNetwork(List<IRemainingItemReplacer> lst, FriendlyByteBuf buf) {
        List<ResourceLocation> replacers = lst.stream().map(arg_0 -> RegistriesHL.REMAINING_REPLACER.getKey(arg_0)).filter(Objects::nonNull).toList();
        buf.writeShort(replacers.size());
        for (ResourceLocation r : replacers) {
            buf.writeResourceLocation(r);
        }
    }

    public static List<IRemainingItemReplacer> fromNetwork(FriendlyByteBuf buf) {
        Registry<IRemainingItemReplacer> g = RegistriesHL.REMAINING_REPLACER;
        ArrayList<IRemainingItemReplacer> lst = new ArrayList<IRemainingItemReplacer>();
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            IRemainingItemReplacer r = (IRemainingItemReplacer)g.get(buf.readResourceLocation());
            if (r == null) continue;
            lst.add(r);
        }
        return lst;
    }
}

