/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.zeith.hammerlib.core.RegistriesHL;
import org.zeith.hammerlib.core.init.RecipesHL;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;

public class HLShapelessRecipe
extends ShapelessRecipe {
    protected final List<IRemainingItemReplacer> inputModifier = new ArrayList<IRemainingItemReplacer>();
    protected final ItemStack result;

    public HLShapelessRecipe(String group, CraftingBookCategory category, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(group, category, result, ingredients);
        this.result = result;
    }

    public HLShapelessRecipe(String group, CraftingBookCategory category, NonNullList<Ingredient> ingredients, ItemStack result, List<IRemainingItemReplacer> replacers) {
        this(group, category, ingredients, result);
        this.inputModifier.addAll(replacers);
    }

    public HLShapelessRecipe addReplacer(ResourceLocation id) {
        IRemainingItemReplacer m = (IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(id);
        if (m != null) {
            this.inputModifier.add(m);
        }
        return this;
    }

    public HLShapelessRecipe addReplacers(ResourceLocation ... id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add((IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public HLShapelessRecipe addReplacers(Iterable<ResourceLocation> id) {
        for (ResourceLocation i : id) {
            this.inputModifier.add((IRemainingItemReplacer)RegistriesHL.REMAINING_REPLACER.get(i));
        }
        this.inputModifier.removeIf(Objects::isNull);
        return this;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipesHL.SHAPELESS_HL_SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput ctr) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)ctr);
        for (IRemainingItemReplacer replacer : this.inputModifier) {
            for (int i = 0; i < remaining.size(); ++i) {
                remaining.set(i, (Object)replacer.replace(ctr, i, (ItemStack)remaining.get(i)));
            }
        }
        return remaining;
    }

    public static class HLSerializer
    implements RecipeSerializer<HLShapelessRecipe> {
        static int MAX_WIDTH = 3;
        static int MAX_HEIGHT = 3;
        private static final MapCodec<HLShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredientList -> {
            if (ingredientList.isEmpty()) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            Object[] ings = (Ingredient[])ingredientList.toArray(Ingredient[]::new);
            return ings.length > MAX_HEIGHT * MAX_WIDTH ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(MAX_HEIGHT * MAX_WIDTH)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ings));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients), (App)ItemStack.CODEC.fieldOf("result").forGetter(hlr -> hlr.result), (App)RegistriesHL.REMAINING_REPLACER.byNameCodec().listOf().fieldOf("replacers").forGetter(hlr -> hlr.inputModifier)).apply((Applicative)inst, HLShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HLShapelessRecipe> STREAM_CODEC = StreamCodec.of(HLSerializer::toNetwork, HLSerializer::fromNetwork);

        public MapCodec<HLShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HLShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static HLShapelessRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            ShapelessRecipe base = (ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.streamCodec().decode((Object)buf);
            HLShapelessRecipe mod = new HLShapelessRecipe(base.getGroup(), base.category(), (NonNullList<Ingredient>)base.getIngredients(), base.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
            mod.inputModifier.addAll(IRemainingItemReplacer.fromNetwork((FriendlyByteBuf)buf));
            return mod;
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, HLShapelessRecipe r) {
            RecipeSerializer.SHAPELESS_RECIPE.streamCodec().encode((Object)buf, (Object)r);
            IRemainingItemReplacer.toNetwork(r.inputModifier, (FriendlyByteBuf)buf);
        }
    }
}

