/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.init;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.zeith.hammerlib.annotations.Ref;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.core.items.ItemGear;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.proxy.HLConstants;

@SimplyRegister(prefix="gears/", creativeTabs={@Ref(value=HLConstants.class, field="HL_TAB")})
public interface GearsHL {
    @RegistryName(value="wooden")
    public static final ItemGear WOODEN_GEAR = GearsHL.gear(TagsHL.Items.GEARS_WOODEN);
    @RegistryName(value="stone")
    public static final ItemGear STONE_GEAR = GearsHL.gear(TagsHL.Items.GEARS_STONE);
    @RegistryName(value="copper")
    public static final ItemGear COPPER_GEAR = GearsHL.gear(TagsHL.Items.GEARS_COPPER);
    @RegistryName(value="iron")
    public static final ItemGear IRON_GEAR = GearsHL.gear(TagsHL.Items.GEARS_IRON);
    @RegistryName(value="gold")
    public static final ItemGear GOLD_GEAR = GearsHL.gear(TagsHL.Items.GEARS_GOLD);
    @RegistryName(value="diamond")
    public static final ItemGear DIAMOND_GEAR = GearsHL.gear(TagsHL.Items.GEARS_DIAMOND);
    @RegistryName(value="netherite")
    public static final ItemGear NETHERITE_GEAR = GearsHL.gear(TagsHL.Items.GEARS_NETHERITE);

    public static ItemGear gear(TagKey<Item> tag) {
        return new ItemGear(new Item.Properties(), tag);
    }

    public static void recipes(RegisterRecipesEvent e) {
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sps", " s ").map('s', Tags.Items.RODS_WOODEN).map('p', ItemTags.PLANKS).result((ItemLike)WOODEN_GEAR)).registerIf(WOODEN_GEAR::defaultRecipe);
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sgs", " s ").map('s', Tags.Items.COBBLESTONES).map('g', (Object)WOODEN_GEAR).result((ItemLike)STONE_GEAR)).registerIf(STONE_GEAR::defaultRecipe);
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sgs", " s ").map('s', Tags.Items.INGOTS_COPPER).map('g', (Object)STONE_GEAR).result((ItemLike)COPPER_GEAR)).registerIf(COPPER_GEAR::defaultRecipe);
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sgs", " s ").map('s', Tags.Items.INGOTS_IRON).map('g', (Object)COPPER_GEAR).result((ItemLike)IRON_GEAR)).registerIf(IRON_GEAR::defaultRecipe);
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sgs", " s ").map('s', Tags.Items.INGOTS_GOLD).map('g', (Object)IRON_GEAR).result((ItemLike)GOLD_GEAR)).registerIf(GOLD_GEAR::defaultRecipe);
        ((ShapedRecipeBuilder)e.shaped().shape(" s ", "sgs", " s ").map('s', Tags.Items.GEMS_DIAMOND).map('g', (Object)GOLD_GEAR).result((ItemLike)DIAMOND_GEAR)).registerIf(DIAMOND_GEAR::defaultRecipe);
        if (NETHERITE_GEAR.defaultRecipe()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)NETHERITE_GEAR);
            e.register(id, (Recipe<?>)new SmithingTransformRecipe(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), Ingredient.of((ItemLike[])new ItemLike[]{DIAMOND_GEAR}), RecipeHelper.fromTag((TagKey<Item>)Tags.Items.INGOTS_NETHERITE), new ItemStack((ItemLike)NETHERITE_GEAR)));
        }
    }
}

