/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render.item;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.CreativeModeTabRegistry;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.render.item.RecenterFilter;
import org.zeith.hammerlib.compat.jei.IJeiPluginHL;
import org.zeith.hammerlib.core.ConfigHL;
import org.zeith.hammerlib.proxy.HLClientProxy;
import org.zeith.hammerlib.util.java.Cast;

@EventBusSubscriber(value={Dist.CLIENT})
public class Stack2ImageRenderer {
    private static final List<RenderQueueItem> QUEUE = new ArrayList<RenderQueueItem>();
    static RenderTarget target;
    static long lastTargetUse;

    public static void queueRenderer(Component type, ItemStack stack, int size, File targetIn) {
        String origin = targetIn.getAbsolutePath();
        int itr = 1;
        while (targetIn.isFile()) {
            int dot = origin.lastIndexOf(".");
            if (dot >= 0) {
                targetIn = new File(origin.substring(0, dot) + " (" + ++itr + ")." + origin.substring(dot + 1));
                continue;
            }
            targetIn = new File(origin + " (" + ++itr + ")");
        }
        File target = targetIn;
        Stack2ImageRenderer.renderItemStack(type, size, stack, image -> Util.ioPool().execute(() -> {
            try {
                Files.createDirectories(target.toPath().getParent(), new FileAttribute[0]);
                image.writeToFile(target);
                image.close();
                BufferedImage buffered = ImageIO.read(target);
                RecenterFilter.recenter(buffered).thenAccept(result -> Util.ioPool().execute(() -> {
                    try {
                        ImageIO.write((RenderedImage)result, "png", target);
                    }
                    catch (Exception exception) {
                        HammerLib.LOG.warn("Couldn't save render", (Throwable)exception);
                    }
                }));
            }
            catch (Exception exception) {
                HammerLib.LOG.warn("Couldn't save render", (Throwable)exception);
            }
        }));
    }

    public static void renderItem(Component type, ItemStack stack, int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        File faild = new File("hammerlib", "renderers" + File.separator + rl.getNamespace());
        File fl = new File(faild, (rl.getPath() + "-" + sdf.format(Date.from(Instant.now())) + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
        Stack2ImageRenderer.queueRenderer(type, stack, size, fl);
    }

    public static void renderAll(int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammerlib", "renderers" + File.separator + "all-" + sdf.format(Date.from(Instant.now())));
        CreativeModeTabRegistry.getSortedCreativeModeTabs().stream().flatMap(tab -> tab.getDisplayItems().stream()).map(stack -> new ItemWithData(stack.getItem(), stack.getComponentsPatch())).distinct().forEach(s -> {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)s.item());
            String suf = "";
            if (s.data() != null && !s.data().isEmpty()) {
                suf = s.data().toString();
            }
            File fl = new File(faild, rl.getNamespace() + File.separator + (rl.getPath() + suf + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
            Stack2ImageRenderer.queueRenderer((Component)Component.literal((String)"Everything"), s.stack(), size, fl);
        });
    }

    public static void renderTab(ResourceLocation tabId, CreativeModeTab tab, int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammerlib", "renderers" + File.separator + tabId.getNamespace() + "_" + tabId.getPath() + "-" + sdf.format(Date.from(Instant.now())));
        tab.getDisplayItems().stream().distinct().map(stack -> new ItemWithData(stack.getItem(), stack.getComponentsPatch())).forEach(s -> {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)s.item());
            String suf = "";
            if (s.data() != null && !s.data().isEmpty()) {
                suf = s.data().toString();
            }
            File fl = new File(faild, (rl.getPath() + suf + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
            Stack2ImageRenderer.queueRenderer((Component)Component.literal((String)("Tab " + String.valueOf(tabId))), s.stack(), size, fl);
        });
    }

    public static void renderMod(String modid, int size) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy-hh.mm.ss");
        File faild = new File("hammerlib", "renderers" + File.separator + modid + "-" + sdf.format(Date.from(Instant.now())));
        CreativeModeTabRegistry.getSortedCreativeModeTabs().stream().flatMap(tab -> tab.getDisplayItems().stream()).filter(item -> BuiltInRegistries.ITEM.getKey((Object)item.getItem()).getNamespace().equals(modid)).map(stack -> new ItemWithData(stack.getItem(), stack.getComponentsPatch())).distinct().forEach(s -> {
            ResourceLocation rl = BuiltInRegistries.ITEM.getKey((Object)s.item());
            String suf = "";
            if (s.data() != null && !s.data().isEmpty()) {
                suf = s.data().toString();
            }
            File fl = new File(faild, (rl.getPath() + suf + ".png").replaceAll("[^a-zA-Z0-9\\.\\-]", "_"));
            Stack2ImageRenderer.queueRenderer((Component)Component.literal((String)("Mod " + modid)), s.stack(), size, fl);
        });
    }

    public static synchronized void renderItemStack(Component type, int resolution, ItemStack stack, Consumer<NativeImage> finishCallback) {
        QUEUE.add(new RenderQueueItem(type, resolution, stack, finishCallback));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFrameStart(ClientTickEvent.Pre eventThatWeDoNotCareMuchAbout) {
        Minecraft mc;
        if (HLClientProxy.RENDER_GUI_ITEM.consumeClick()) {
            mc = Minecraft.getInstance();
            Cast.optionally(mc.screen, AbstractContainerScreen.class).map(AbstractContainerScreen::getSlotUnderMouse).map(Slot::getItem).or(() -> IJeiPluginHL.get().getIngredientUnderMouseJEI(ItemStack.class)).ifPresent(stack -> {
                int res = Mth.clamp((int)ConfigHL.INSTANCE.get((LogicalSide)LogicalSide.CLIENT).clientSide.guiItemRenderResolution, (int)16, (int)32768);
                Stack2ImageRenderer.renderItem((Component)Component.literal((String)"Hotkey"), stack, res);
            });
        }
        if (QUEUE.isEmpty()) {
            if (target != null && System.currentTimeMillis() - lastTargetUse > 500L) {
                target.destroyBuffers();
                target = null;
            }
            return;
        }
        mc = Minecraft.getInstance();
        RenderQueueItem elem = QUEUE.removeFirst();
        Component a = elem.work;
        ItemStack stack2 = elem.stack();
        int resolution = elem.resolution();
        Matrix4fStack pStack = RenderSystem.getModelViewStack();
        GuiGraphics guiGraphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
        if (target == null) {
            target = new RenderTarget(true){};
        }
        if (Stack2ImageRenderer.target.width < resolution || Stack2ImageRenderer.target.height < resolution) {
            target.resize(resolution, resolution, Minecraft.ON_OSX);
        }
        float max = (float)resolution * 16.0f / (float)resolution;
        Matrix4f proj = new Matrix4f().setOrtho(0.0f, max, max, 0.0f, -3000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)proj, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        pStack.pushMatrix();
        pStack.identity();
        RenderSystem.applyModelViewMatrix();
        target.bindWrite(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        RenderSystem.clearDepth((double)1.0);
        RenderSystem.clear((int)16640, (boolean)Minecraft.ON_OSX);
        Lighting.setupFor3DItems();
        RenderSystem.enableCull();
        guiGraphics.renderItem(stack2, 0, 0);
        NativeImage img = new NativeImage(resolution, resolution, false);
        target.bindRead();
        img.downloadTexture(0, false);
        img.flipY();
        pStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        target.unbindWrite();
        elem.finishCallback.accept(img);
        if (a != null) {
            SystemToast.addOrUpdate((ToastComponent)mc.toast, (SystemToast.SystemToastId)SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)a.copy().append((Component)Component.literal((String)": Rendered!").withStyle(ChatFormatting.GREEN)), (Component)elem.stack.getDisplayName());
        }
        lastTargetUse = System.currentTimeMillis();
    }

    private record RenderQueueItem(Component work, int resolution, ItemStack stack, Consumer<NativeImage> finishCallback) {
    }

    private record ItemWithData(Item item, DataComponentPatch data) {
        public ItemStack stack() {
            ItemStack stack = new ItemStack((ItemLike)this.item);
            stack.applyComponents(this.data);
            return stack;
        }
    }
}

