/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.recipes;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.api.registrars.SerializableRecipeType;

public abstract class BaseRecipe<R extends BaseRecipe<R, INPUT>, INPUT extends RecipeInput>
implements Recipe<INPUT> {
    protected final SerializableRecipeType<R> type = this.getRecipeType();
    protected String group = "";
    protected boolean isHidden;
    protected NonNullList<Ingredient> vanillaIngredients = NonNullList.create();
    protected ItemStack vanillaResult = ItemStack.EMPTY;

    public BaseRecipe(String group) {
        this.group = group == null ? "" : group;
    }

    protected abstract SerializableRecipeType<R> getRecipeType();

    public NonNullList<Ingredient> getIngredients() {
        return this.vanillaIngredients;
    }

    public boolean isSpecial() {
        return this.isHidden;
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getToastSymbol() {
        return this.type.getToastSymbol(this);
    }

    public boolean matches(INPUT container, Level level) {
        return false;
    }

    public ItemStack assemble(INPUT container, HolderLookup.Provider provider) {
        return this.vanillaResult.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.vanillaResult.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return this.type;
    }

    public RecipeType<?> getType() {
        return this.type;
    }
}

