/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.lighting.ColoredLight;
import org.zeith.hammerlib.api.lighting.HandleLightOverrideEvent;
import org.zeith.hammerlib.api.lighting.impl.IGlowingEntity;
import org.zeith.hammerlib.api.lighting.impl.IGlowingItem;

public class ColoredLightManager {
    private static final List<Function<Float, Stream<ColoredLight>>> lightGenerators = new ArrayList<Function<Float, Stream<ColoredLight>>>();
    public static BooleanSupplier COLORED_LIGHTING_ENABLED = () -> false;
    public static BooleanSupplier SHADER_UNIFORM_SETUP = () -> false;
    public static BooleanSupplier BIND_TERRAIN = () -> false;
    public static BooleanSupplier BIND_ENTITY = () -> false;
    public static BooleanSupplier UNBIND_TERRAIN = () -> false;
    public static BooleanSupplier UNBIND_ENTITY = () -> false;
    public static IntSupplier UNIFORM_LIGHT_COUNT = () -> 0;
    public static int LAST_LIGHTS;

    public static boolean isColoredLightActive() {
        return COLORED_LIGHTING_ENABLED.getAsBoolean();
    }

    public static <A, B, C> Function<A, C> dfunc(Function<A, B> fa, Function<B, C> fb) {
        return a -> fb.apply(fa.apply(a));
    }

    public static Player getClientPlayer() {
        return HammerLib.PROXY.getClientPlayer();
    }

    public static void addGenerator(Function<Float, Stream<ColoredLight>> gen) {
        lightGenerators.add(gen);
    }

    public static Stream<ColoredLight> generate(float partialTicks) {
        return lightGenerators.stream().flatMap(f -> (Stream)f.apply(Float.valueOf(partialTicks))).filter(Predicates.notNull());
    }

    static {
        ColoredLightManager.addGenerator(partialTicks -> {
            Player pl = ColoredLightManager.getClientPlayer();
            if (pl != null) {
                List ents = pl.level().getEntitiesOfClass(Entity.class, pl.getBoundingBox().inflate(128.0));
                Stream players = ents.stream().flatMap(ent -> {
                    ItemEntity ei;
                    ItemStack item;
                    IGlowingItem igi;
                    Stream.Builder<ColoredLight> lights = Stream.builder();
                    if (ent instanceof LivingEntity) {
                        ItemStack off;
                        LivingEntity base = (LivingEntity)ent;
                        ItemStack main = base.getMainHandItem();
                        IGlowingItem igi2 = IGlowingItem.fromStack(main);
                        if (igi2 != null) {
                            lights.add(igi2.produceColoredLight((Entity)base, main));
                        }
                        if ((igi2 = IGlowingItem.fromStack(off = base.getOffhandItem())) != null) {
                            lights.add(igi2.produceColoredLight((Entity)base, off));
                        }
                    } else if (ent instanceof ItemEntity && (igi = IGlowingItem.fromStack(item = (ei = (ItemEntity)ent).getItem())) != null) {
                        lights.add(igi.produceColoredLight((Entity)ei, item));
                    }
                    return lights.build().filter(Predicates.notNull()).map(l -> l.reposition((Entity)ent, partialTicks.floatValue()));
                });
                Stream<ColoredLight> entities = Stream.concat(players, ents.stream().map(e -> {
                    ColoredLight l = e instanceof IGlowingEntity ? ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue()) : null;
                    HandleLightOverrideEvent evt = new HandleLightOverrideEvent(e, partialTicks.floatValue(), l);
                    HammerLib.postEvent(evt);
                    return evt.getNewLight();
                }));
                entities = Stream.concat(entities, HammerLib.PROXY.getGlowingParticles(partialTicks.floatValue()));
                Stream<ColoredLight> tiles = BlockAPI.getAllLoadedBlockEntities(pl.level()).stream().map(e -> {
                    ColoredLight l = e instanceof IGlowingEntity ? ((IGlowingEntity)e).produceColoredLight(partialTicks.floatValue()) : null;
                    HandleLightOverrideEvent evt = new HandleLightOverrideEvent(e, partialTicks.floatValue(), l);
                    HammerLib.postEvent(evt);
                    return evt.getNewLight();
                });
                return Stream.concat(tiles, entities);
            }
            return Stream.empty();
        });
    }
}

