/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.modscan.ModAnnotation;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.annotations.ProvideRecipes;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.IRecipeProvider;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.api.proxy.IProxy;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.compat.base.CompatList;
import org.zeith.hammerlib.compat.base._hl.BaseHLCompat;
import org.zeith.hammerlib.core.ConfigHL;
import org.zeith.hammerlib.core.adapter.ConfigAdapter;
import org.zeith.hammerlib.core.adapter.CreativeTabAdapter;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.core.adapter.RegistryAdapter;
import org.zeith.hammerlib.core.command.CommandHammerLib;
import org.zeith.hammerlib.core.init.TagsHL;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLClientProxy;
import org.zeith.hammerlib.proxy.HLCommonProxy;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.tiles.tooltip.own.impl.TooltipRenderEngine;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.hammerlib.util.ZeithLinkRepository;
import org.zeith.hammerlib.util.charging.ItemChargeHelper;
import org.zeith.hammerlib.util.configured.io.UnsafeHax;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

@Mod(value="hammerlib")
public class HammerLib {
    public static final Logger LOG = LoggerFactory.getLogger(HammerLib.class);
    public static final HLCommonProxy PROXY = (HLCommonProxy)IProxy.create(() -> HLClientProxy::new, () -> HLCommonProxy::new);
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    private static CompatList<BaseHLCompat> hlCompatList;
    public static boolean logHLEvents;

    public HammerLib(IEventBus modEventBus) {
        CommonMessages.printMessageOnIllegalRedistribution(HammerLib.class, LOG, "HammerLib", "https://www.curseforge.com/minecraft/mc-mods/hammer-lib");
        hlCompatList = CompatList.gather(BaseHLCompat.class, CompatContext.builder(modEventBus).build());
        modEventBus.register((Object)this);
        PROXY.construct(modEventBus);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        LanguageAdapter.registerMod("hammerlib");
        TagsHL.init();
        ZeithLinkRepository.initialize();
        ItemChargeHelper.setup();
        ScanDataHelper.lookupAnnotatedObjects(ProvideRecipes.class).forEach(data -> {
            IRecipeProvider provider;
            FMLModContainer ow = data.getOwnerMod().orElse(null);
            if (ow == null) {
                LOG.info("Skipping mod-less @ProvideRecipes annotation in " + String.valueOf(data.getOwnerClass()));
                return;
            }
            Class<?> c = data.getOwnerClass();
            if (IRecipeProvider.class.isAssignableFrom(c) && (provider = (IRecipeProvider)UnsafeHax.unitializedInstance(c)) != null) {
                IEventBus bus = ow.getEventBus();
                bus.addListener(provider::provideRecipes);
                bus.addListener(provider::spoofRecipes);
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(CreativeTab.RegisterTab.class).forEach(data -> {
            if (data.getTargetType() == ElementType.FIELD) {
                data.getOwnerMod().ifPresent(mc -> mc.getEventBus().addListener(e -> {
                    Optional<BiConsumer<ResourceLocation, BiConsumer>> registrar = RegistryAdapter.createRegisterer(e, Registries.CREATIVE_MODE_TAB, null);
                    registrar.ifPresent(register -> {
                        Optional<CreativeTab> tab = ReflectionUtil.getStaticFinalField(data.getOwnerClass(), data.getMemberName());
                        tab.ifPresent(t0 -> t0.register(t -> {
                            CreativeModeTab.Builder tabBuilder = CreativeModeTab.builder();
                            t.factory().accept(tabBuilder);
                            CreativeModeTab ct = tabBuilder.build();
                            register.accept(t.id(), ct);
                            return ct;
                        }));
                    });
                }));
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(SimplyRegister.class).forEach(data -> {
            if (data.getTargetType() == ElementType.TYPE) {
                data.getOwnerMod().ifPresent(mc -> {
                    LOG.info("Hooked " + String.valueOf(data.clazz()) + " from " + mc.getModId() + " to register it's stuff.");
                    mc.getEventBus().addListener(event -> RegistryAdapter.register(event, data.getOwnerClass(), mc, data.getProperty("prefix").map(Objects::toString).orElse("")));
                });
            }
        });
        ConfigAdapter.setup();
        List bothSides = Stream.of(Dist.values()).map(dst -> new ModAnnotation.EnumHolder("Lnet/neoforged/api/distmarker/Dist;", dst.name())).collect(Collectors.toList());
        ScanDataHelper.lookupAnnotatedObjects(Setup.class).forEach(data -> {
            List lst;
            Object side = data.getProperty("side").orElse(bothSides);
            if (side instanceof List && !(lst = (List)side).isEmpty()) {
                for (Object o : lst) {
                    if (!(o instanceof ModAnnotation.EnumHolder)) continue;
                    ModAnnotation.EnumHolder h = (ModAnnotation.EnumHolder)o;
                    if (!FMLEnvironment.dist.name().equals(h.value())) continue;
                    if (data.getTargetType() == ElementType.METHOD) {
                        LOG.info("Injecting setup into " + data.clazz().getClassName());
                        data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.setup(event, data.getOwnerClass(), data.getMemberName())));
                    }
                    break;
                }
            } else {
                LOG.warn("What the hell is this? " + String.valueOf(data.parent.clazz()) + "->" + data.getMemberName());
            }
        });
        ScanDataHelper.lookupAnnotatedObjects(ClientSetup.class).forEach(data -> {
            if (data.getTargetType() == ElementType.METHOD) {
                LOG.info("Injecting client-setup into " + data.clazz().getClassName());
                data.getOwnerMod().map(FMLModContainer::getEventBus).ifPresent(b -> b.addListener(event -> RegistryAdapter.clientSetup(event, data.getOwnerClass(), data.getMemberName())));
            }
        });
        NBTSerializationHelper.construct();
    }

    @SubscribeEvent
    public void constructMod(FMLConstructModEvent e0) {
        ModList.get().forEachModContainer((modid, container) -> {
            if (container instanceof FMLModContainer) {
                FMLModContainer ctr = (FMLModContainer)container;
                IEventBus bus = ctr.getEventBus();
                bus.addListener(e -> ctr.getEventBus().post((Event)new FMLFingerprintCheckEvent((ModContainer)ctr)));
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent e) {
        PROXY.clientSetup();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(RegisterGuiLayersEvent e) {
        e.registerAboveAll(HLConstants.id("tooltip_engine"), (LayeredDraw.Layer)new TooltipRenderEngine());
    }

    @SubscribeEvent
    public void finish(FMLLoadCompleteEvent e) {
        PROXY.finishLoading();
        CreativeTabAdapter.deque();
    }

    public void registerCommands(RegisterCommandsEvent e) {
        CommandHammerLib.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    public static <T extends Event> T postEvent(T evt) {
        ConfigHL cfgs = ConfigHL.INSTANCE.getCurrent();
        if (logHLEvents || cfgs != null && cfgs.internal.logHLBusEvents) {
            LOG.info("[HammerLib.postEvent] {}", evt);
        }
        return (T)EVENT_BUS.post(evt);
    }

    public static <T extends Event> T postNeoEvent(T evt) {
        ConfigHL cfgs = ConfigHL.INSTANCE.getCurrent();
        if (logHLEvents || cfgs != null && cfgs.internal.logNFBusEvents) {
            LOG.info("[HammerLib.postNeoEvent] {}", evt);
        }
        return (T)NeoForge.EVENT_BUS.post(evt);
    }

    public static CompatList<BaseHLCompat> getHLCompats() {
        return hlCompatList;
    }

    static {
        logHLEvents = String.valueOf(System.getProperty("hammerlib.logevents")).toLowerCase(Locale.ROOT).contains("true");
    }
}

