/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.core.commands.BackCommand;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;

public class RandomTeleportCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.teleport.invalidPosition"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpr").requires(p -> p.hasPermission(2))).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).getEntityOrException()), Optional.empty()))).then(((RequiredArgumentBuilder)Commands.argument((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).getEntityOrException()), Optional.of(DoubleArgumentType.getDouble((CommandContext)c, (String)"radius"))))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<CommandSourceStack>)c, EntityArgument.getEntities((CommandContext)c, (String)"targets"), Optional.of(DoubleArgumentType.getDouble((CommandContext)c, (String)"radius"))))))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(c -> RandomTeleportCommand.teleportRandom((CommandContext<CommandSourceStack>)c, EntityArgument.getEntities((CommandContext)c, (String)"targets"), Optional.empty())));
    }

    private static int teleportRandom(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, Optional<Double> optRadius) throws CommandSyntaxException {
        double zMax;
        double zMin;
        double xMax;
        double xMin;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        RandomSource random = level.getRandom();
        WorldBorder border = level.getWorldBorder();
        if (optRadius.isPresent()) {
            double centerZ;
            double radius = optRadius.get();
            try {
                Entity src = source.getEntityOrException();
                var17_11 = src.getX();
                centerZ = src.getZ();
            }
            catch (CommandSyntaxException e) {
                var17_11 = border.getCenterX();
                centerZ = border.getCenterZ();
            }
            xMin = var17_11 - radius;
            xMax = var17_11 + radius;
            zMin = centerZ - radius;
            zMax = centerZ + radius;
        } else {
            double centerX = border.getCenterX();
            var17_11 = border.getCenterZ();
            double half = border.getSize() / 2.0;
            xMin = centerX - half;
            xMax = centerX + half;
            zMin = var17_11 - half;
            zMax = var17_11 + half;
        }
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        set.add(RelativeMovement.X_ROT);
        set.add(RelativeMovement.Y_ROT);
        for (Entity entity : targets) {
            double sampledX = xMin + random.nextDouble() * (xMax - xMin);
            double sampledZ = zMin + random.nextDouble() * (zMax - zMin);
            BlockPos clamped = border.clampToBounds(sampledX, 0.0, sampledZ);
            double x = clamped.getX();
            double z = clamped.getZ();
            int xi = Mth.floor((double)x);
            int zi = Mth.floor((double)z);
            int finalY = 70;
            BlockPos blockPos = BlockPos.containing((double)x, (double)finalY, (double)z);
            if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
                throw INVALID_POSITION.create();
            }
            RandomTeleportCommand.performTeleport(source, entity, level, x, finalY, z, set);
        }
        Vec3 example = targets.iterator().next().position();
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), RandomTeleportCommand.formatDouble(example.x), RandomTeleportCommand.formatDouble(example.y), RandomTeleportCommand.formatDouble(example.z)}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), RandomTeleportCommand.formatDouble(example.x), RandomTeleportCommand.formatDouble(example.y), RandomTeleportCommand.formatDouble(example.z)}), true);
        }
        return targets.size();
    }

    private static void performTeleport(CommandSourceStack source, Entity entity, ServerLevel level, double x, double y, double z, Set<RelativeMovement> relativeList) throws CommandSyntaxException {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            throw INVALID_POSITION.create();
        }
        float f = Mth.wrapDegrees((float)entity.getYRot());
        float g = Mth.wrapDegrees((float)entity.getXRot());
        BlockPos oldPos = entity.blockPosition();
        ResourceKey oldDim = entity.level().dimension();
        if (entity.teleportTo(level, x, y, z, relativeList, f, g)) {
            LivingEntity livingEntity;
            BackCommand.onTeleported(entity, oldPos, (ResourceKey<Level>)oldDim);
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isFallFlying()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                entity.setOnGround(true);
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                pathfinderMob.getNavigation().stop();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

