/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.LenientListCodec;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidContainerList
implements Iterable<Category> {
    public static final Codec<FluidContainerList> CODEC = LenientListCodec.of(Category.CODEC).xmap(FluidContainerList::new, FluidContainerList::getCategories);
    private final Map<Item, Category> emptyToFilledMap = new IdentityHashMap<Item, Category>();

    public FluidContainerList(List<Category> categoryList) {
        categoryList.forEach(this::addCategory);
    }

    public FluidContainerList() {
    }

    private void addCategory(Category newCategory) {
        if (!newCategory.isEmpty()) {
            if (this.emptyToFilledMap.containsKey(newCategory.emptyContainer)) {
                Category c = this.emptyToFilledMap.get(newCategory.emptyContainer);
                if (c.containerCapacity == newCategory.containerCapacity) {
                    c.filled.addAll(newCategory.filled);
                }
            } else {
                this.emptyToFilledMap.put(newCategory.emptyContainer, newCategory);
            }
        }
    }

    public Optional<Item> getEmpty(Item filledContainer) {
        for (Map.Entry<Item, Category> e : this.emptyToFilledMap.entrySet()) {
            if (!e.getValue().getFilledItems().contains(filledContainer)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public Optional<Item> getFilled(Item emptyContainer) {
        Category c = this.emptyToFilledMap.get(emptyContainer);
        if (c != null) {
            return c.getFirstFilled();
        }
        return Optional.empty();
    }

    public Optional<Category> getCategoryFromEmpty(Item emptyContainer) {
        return Optional.ofNullable(this.emptyToFilledMap.get(emptyContainer));
    }

    public Optional<Category> getCategoryFromFilled(Item filledContainer) {
        return this.getEmpty(filledContainer).map(this.emptyToFilledMap::get);
    }

    public Collection<Item> getPossibleFilled() {
        ArrayList<Item> list = new ArrayList<Item>();
        this.emptyToFilledMap.values().forEach(c -> list.addAll(c.filled));
        return list;
    }

    public Collection<Item> getPossibleEmpty() {
        return this.emptyToFilledMap.keySet();
    }

    public List<Category> getCategories() {
        return List.copyOf(this.emptyToFilledMap.values());
    }

    @Override
    @NotNull
    public Iterator<Category> iterator() {
        return this.emptyToFilledMap.values().iterator();
    }

    protected void merge(FluidContainerList other) {
        other.emptyToFilledMap.values().forEach(this::addCategory);
    }

    protected void add(Item empty, Item filled, int amount) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((Item)i, amount));
        c.addItem(filled);
    }

    protected void add(Item empty, Item filled, int amount, SoundEvent fillSound, SoundEvent emptySound) {
        Category c = this.emptyToFilledMap.computeIfAbsent(empty, i -> new Category((Item)i, amount));
        c.addItem(filled);
        if (c.fillSound == null) {
            c.fillSound = fillSound;
        }
        if (c.emptySound == null) {
            c.emptySound = emptySound;
        }
    }

    public static class Category {
        private static final Supplier<Category> EMPTY = Suppliers.memoize(() -> new Category((Item)BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getDefaultKey()), 1));
        public static final Codec<Category> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("empty").forGetter(c -> c.emptyContainer), (App)SoftFluid.Capacity.INT_CODEC.fieldOf("capacity").forGetter(Category::getCapacity), (App)BuiltInRegistries.ITEM.byNameCodec().listOf().fieldOf("filled").forGetter(c -> c.filled), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("fill_sound").forGetter(c -> Optional.ofNullable(c.getFillSound())), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().optionalFieldOf("empty_sound").forGetter(c -> Optional.ofNullable(c.getEmptySound()))).apply((Applicative)instance, Category::decode));
        private final Item emptyContainer;
        private final int containerCapacity;
        private SoundEvent fillSound;
        private SoundEvent emptySound;
        private final List<Item> filled = new ArrayList<Item>();

        private Category(Item emptyContainer, int capacity, @Nullable SoundEvent fillSound, @Nullable SoundEvent emptySound) {
            this.emptyContainer = emptyContainer;
            this.containerCapacity = capacity;
            this.fillSound = fillSound;
            this.emptySound = emptySound;
        }

        private Category(Item emptyContainer, int capacity) {
            this(emptyContainer, capacity, null, null);
        }

        private static Category decode(Item empty, int capacity, List<Item> filled) {
            return Category.decode(empty, capacity, filled, Optional.empty(), Optional.empty());
        }

        private static Category decode(Item empty, int capacity, List<Item> filled, Optional<SoundEvent> fillSound, Optional<SoundEvent> emptySound) {
            Category category = new Category(empty, capacity, fillSound.orElse(null), emptySound.orElse(null));
            filled.forEach(category::addItem);
            if (category.isEmpty()) {
                return EMPTY.get();
            }
            return category;
        }

        public Item getEmptyContainer() {
            return this.emptyContainer;
        }

        public int getCapacity() {
            return this.containerCapacity;
        }

        @Deprecated(forRemoval=true)
        public int getAmount() {
            return this.containerCapacity;
        }

        private void addItem(Item i) {
            if (!i.getDefaultInstance().isEmpty() && !this.filled.contains(i)) {
                this.filled.add(i);
            }
        }

        public SoundEvent getFillSound() {
            return this.fillSound == null ? SoundEvents.BOTTLE_FILL : this.fillSound;
        }

        public SoundEvent getEmptySound() {
            return this.emptySound == null ? SoundEvents.BOTTLE_EMPTY : this.emptySound;
        }

        public List<Item> getFilledItems() {
            return this.filled;
        }

        public boolean isEmpty() {
            return this.filled.isEmpty();
        }

        public Optional<Item> getFirstFilled() {
            return this.filled.stream().findFirst();
        }
    }
}

