/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.fluids;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import stepsword.mahoutsukai.dataattachments.chunks.IChunkMahou;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MurkyWaterBlock
extends LiquidBlock {
    private static boolean pushesEntity;
    protected String name;
    public static HashSet<ChunkDim> murkies;

    public MurkyWaterBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
        this.name = "murky_water";
    }

    public MurkyWaterBlock() {
        super((FlowingFluid)ModFluids.MURKY_FLOW.get(), BlockBehaviour.Properties.of().liquid().noLootTable().noCollission().replaceable().strength(100.0f));
        this.fluid = (FlowingFluid)ModFluids.MURKY_STILL.get();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.isClientSide) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.getChunk(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().remove((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.getPos(), EffectUtil.getDimension(world)));
        }
        super.onRemove(state, world, pos, state2, v1);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.isClientSide) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.getChunk(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().add((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.getPos(), EffectUtil.getDimension(world)));
        }
        super.onPlace(state, world, pos, oldState, isMoving);
    }

    public static void murkyUpdateTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide && event.getLevel().getGameTime() % 4L == 0L) {
            for (ChunkDim p : murkies) {
                ServerLevel world = EffectUtil.getNewDimensionByName((ServerLevel)event.getLevel(), p.dim);
                LevelChunk c = world.getChunk(p.pos.x, p.pos.z);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.getWorldPosition(), (Level)EffectUtil.getNewDimensionByName((ServerLevel)event.getLevel(), p.dim), new ChunkMahouPacket(chunkMahou.getLakeBlocks(), p.pos.x, p.pos.z));
            }
            murkies.clear();
        }
    }

    static {
        murkies = new HashSet();
    }
}

