/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.dataattachments.worldsave;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import stepsword.mahoutsukai.dataattachments.worldsave.FictionData;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;

public class WorldMahouStorage {
    public static final String realityMarblePlayers = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_LIST";
    public static final String marblePlayerID = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_ID";
    public static final String marblePlayerSpawnX = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_X";
    public static final String marblePlayerSpawnY = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Y";
    public static final String marblePlayerSpawnZ = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Z";
    public static final String contractPlayers = "MAHOUTSUKAI_CONTRACT_PLAYER_LIST";
    public static final String contractPlayerIDA = "MAHOUTSUKAI_CONTRACT_PLAYER_A";
    public static final String contractPlayerIDB = "MAHOUTSUKAI_CONTRACT_PLAYER_B";

    public static CompoundTag writeNBT(MahouSavedData instance) {
        CompoundTag compound = new CompoundTag();
        CompoundTag reality = new CompoundTag();
        int z = 0;
        for (UUID tmp : instance.getAllSpawns().keySet()) {
            BlockPos pos = instance.getAllSpawns().get(tmp);
            if (pos == null) continue;
            CompoundTag nbttmp = new CompoundTag();
            nbttmp.putUUID(marblePlayerID, tmp);
            nbttmp.putInt(marblePlayerSpawnX, pos.getX());
            nbttmp.putInt(marblePlayerSpawnY, pos.getY());
            nbttmp.putInt(marblePlayerSpawnZ, pos.getZ());
            reality.put("MAHOUTSUKAI_PLAYER_ID_" + z, (Tag)nbttmp);
            ++z;
        }
        compound.put(realityMarblePlayers, (Tag)reality);
        CompoundTag contracts = new CompoundTag();
        CompoundTag nbtcctmp = null;
        int c = 0;
        for (UUID tmp : instance.getPlayerContracts().keySet()) {
            Collection coll = instance.getPlayerContracts().get((Object)tmp);
            for (UUID tmp2 : coll) {
                nbtcctmp = new CompoundTag();
                nbtcctmp.putUUID(contractPlayerIDA, tmp);
                nbtcctmp.putUUID(contractPlayerIDB, tmp2);
                contracts.put("MAHOUTSUKAI_CONTRACT_ID_" + c, (Tag)nbtcctmp);
                ++c;
            }
        }
        compound.put(contractPlayers, (Tag)contracts);
        int ds = 0;
        for (FictionData d : instance.playerCreations.keySet()) {
            compound.put("MAHOUTSUKAI_STORED_FICTION_" + ds, (Tag)d.toNBT());
            ++ds;
        }
        return compound;
    }

    public static void readNBT(MahouSavedData instance, CompoundTag nbt) {
        if (nbt.contains(realityMarblePlayers)) {
            for (String tmp : ((CompoundTag)nbt.get(realityMarblePlayers)).getAllKeys()) {
                CompoundTag nbttmp = (CompoundTag)((CompoundTag)nbt.get(realityMarblePlayers)).get(tmp);
                if (nbttmp == null || !nbttmp.hasUUID(marblePlayerID)) continue;
                UUID uuid = nbttmp.getUUID(marblePlayerID);
                BlockPos pos = new BlockPos(nbttmp.getInt(marblePlayerSpawnX), nbttmp.getInt(marblePlayerSpawnY), nbttmp.getInt(marblePlayerSpawnZ));
                instance.getAllSpawns().put(uuid, pos);
            }
        }
        if (nbt.contains(contractPlayers)) {
            for (String tmp : ((CompoundTag)nbt.get(contractPlayers)).getAllKeys()) {
                CompoundTag nbtc = (CompoundTag)((CompoundTag)nbt.get(contractPlayers)).get(tmp);
                if (!nbtc.hasUUID(contractPlayerIDA) || !nbtc.hasUUID(contractPlayerIDB)) continue;
                instance.getPlayerContracts().put((Object)nbtc.getUUID(contractPlayerIDA), (Object)nbtc.getUUID(contractPlayerIDB));
                instance.getPlayerContracts().put((Object)nbtc.getUUID(contractPlayerIDB), (Object)nbtc.getUUID(contractPlayerIDA));
            }
        }
        int ds = 0;
        while (nbt.contains("MAHOUTSUKAI_STORED_FICTION_" + ds)) {
            FictionData d = FictionData.fromNBT((CompoundTag)nbt.get("MAHOUTSUKAI_STORED_FICTION_" + ds));
            instance.playerCreations.put(d, d.uuid);
            ++ds;
        }
    }
}

