/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerUtil {
    public static int insertStack(ItemStack stack, Container container) {
        return ContainerUtil.insertStack(stack, container, false);
    }

    public static int insertStack(ItemStack stack, Container container, boolean simulate) {
        int slot;
        ItemStack copy = stack.copy();
        for (slot = 0; slot < container.getContainerSize(); ++slot) {
            ItemStack inSlot = container.getItem(slot);
            if (inSlot.isEmpty() || !ContainerUtil.canCombine(copy, inSlot, container.getMaxStackSize()) || !container.canPlaceItem(slot, copy)) continue;
            int add = Math.min(copy.getCount(), inSlot.getMaxStackSize() - inSlot.getCount());
            if (!simulate) {
                inSlot.grow(add);
                container.setItem(slot, inSlot);
            }
            copy.shrink(add);
            if (!copy.isEmpty()) continue;
            return 0;
        }
        for (slot = 0; slot < container.getContainerSize(); ++slot) {
            if (!container.getItem(slot).isEmpty() || !container.canPlaceItem(slot, copy)) continue;
            if (!simulate) {
                container.setItem(slot, copy);
            }
            return 0;
        }
        return copy.getCount();
    }

    public static boolean canCombine(ItemStack stack, ItemStack combineWith) {
        return ContainerUtil.canCombine(stack, combineWith, 64);
    }

    public static boolean canCombine(ItemStack stack, ItemStack combineWith, int maxStackSize) {
        return !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)combineWith) && stack.isStackable() && combineWith.getCount() < combineWith.getMaxStackSize() && combineWith.getCount() < maxStackSize;
    }

    @NotNull
    public static ItemStack insertItem(Container container, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = container.getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), container.getMaxStackSize())) {
                return stack;
            }
            if (!ContainerUtil.canCombine(stack, stackInSlot)) {
                return stack;
            }
            if (!container.canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), container.getMaxStackSize()) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    container.setItem(slot, copy);
                    container.setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                container.setItem(slot, copy);
                container.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!container.canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), container.getMaxStackSize());
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                container.setItem(slot, stack.split(m));
                container.setChanged();
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            container.setItem(slot, stack);
            container.setChanged();
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public static ItemStack extractItem(Container container, int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = container.getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = container.removeItem(slot, m);
        container.setChanged();
        return decrStackSize;
    }
}

