/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.containers;

import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.containers.DataManagerContainer;
import net.creeperhost.polylib.containers.ModularGuiContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public abstract class PolyBlockContainerMenu<T extends PolyBlockEntity>
extends ModularGuiContainerMenu
implements DataManagerContainer {
    public T tile;
    public Player player;

    public PolyBlockContainerMenu(@Nullable MenuType<?> type, int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        super(type, windowId, playerInv);
        this.player = playerInv.player;
        this.tile = PolyBlockContainerMenu.getClientTile(playerInv, extraData);
    }

    public PolyBlockContainerMenu(@Nullable MenuType<?> type, int windowId, Inventory playerInv, T tile) {
        super(type, windowId, playerInv);
        this.player = playerInv.player;
        this.tile = tile;
        ((PolyBlockEntity)this.tile).onPlayerOpenContainer(playerInv.player);
    }

    protected static <T extends PolyBlockEntity> T getClientTile(Inventory playerInv, FriendlyByteBuf extraData) {
        return (T)((PolyBlockEntity)playerInv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public void removed(Player player) {
        super.removed(player);
        ((PolyBlockEntity)this.tile).onPlayerCloseContainer(player);
    }

    public boolean stillValid(Player player) {
        if (this.tile.getLevel().getBlockEntity(this.tile.getBlockPos()) != this.tile) {
            return false;
        }
        return player.distanceToSqr((double)this.tile.getBlockPos().getX() + 0.5, (double)this.tile.getBlockPos().getY() + 0.5, (double)this.tile.getBlockPos().getZ() + 0.5) <= (double)((PolyBlockEntity)this.tile).getAccessDistanceSq();
    }

    @Override
    public T getBlockEntity() {
        return this.tile;
    }
}

