/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.geometry;

import java.util.Objects;

public final class Borders {
    private double top;
    private double left;
    private double bottom;
    private double right;

    public Borders(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public static Borders create(double borders) {
        return Borders.create(borders, borders);
    }

    public static Borders create(double leftRight, double topBottom) {
        return Borders.create(topBottom, leftRight, topBottom, leftRight);
    }

    public static Borders create(double top, double left, double bottom, double right) {
        return new Borders(top, left, bottom, right);
    }

    public double top() {
        return this.top;
    }

    public double left() {
        return this.left;
    }

    public double bottom() {
        return this.bottom;
    }

    public double right() {
        return this.right;
    }

    public Borders setTop(double top) {
        this.top = top;
        return this;
    }

    public Borders setLeft(double left) {
        this.left = left;
        return this;
    }

    public Borders setBottom(double bottom) {
        this.bottom = bottom;
        return this;
    }

    public Borders setRight(double right) {
        this.right = right;
        return this;
    }

    public Borders setTopBottom(double topBottom) {
        return this.setTop(topBottom).setBottom(topBottom);
    }

    public Borders setLeftRight(double leftRight) {
        return this.setLeft(leftRight).setLeftRight(leftRight);
    }

    public Borders setBorders(double borders) {
        return this.setBorders(borders, borders);
    }

    public Borders setBorders(double topBottom, double leftRight) {
        return this.setBorders(topBottom, leftRight, topBottom, leftRight);
    }

    public Borders setBorders(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Borders that = (Borders)obj;
        return Double.doubleToLongBits(this.top) == Double.doubleToLongBits(that.top) && Double.doubleToLongBits(this.left) == Double.doubleToLongBits(that.left) && Double.doubleToLongBits(this.bottom) == Double.doubleToLongBits(that.bottom) && Double.doubleToLongBits(this.right) == Double.doubleToLongBits(that.right);
    }

    public int hashCode() {
        return Objects.hash(this.top, this.left, this.bottom, this.right);
    }

    public String toString() {
        return "Borders[top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right + "]";
    }
}

