/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFStructures;
import twilightforest.init.custom.Enforcements;
import twilightforest.util.Enforcement;
import twilightforest.util.Restriction;

public class Restrictions {
    public static final Codec<Holder<Restriction>> CODEC = RegistryFileCodec.create(TFRegistries.Keys.RESTRICTIONS, Restriction.CODEC, (boolean)false);
    public static final ResourceKey<Restriction> DARK_FOREST = Restrictions.makeKey(TFBiomes.DARK_FOREST.location());
    public static final ResourceKey<Restriction> DARK_FOREST_CENTER = Restrictions.makeKey(TFBiomes.DARK_FOREST_CENTER.location());
    public static final ResourceKey<Restriction> FINAL_PLATEAU = Restrictions.makeKey(TFBiomes.FINAL_PLATEAU.location());
    public static final ResourceKey<Restriction> FIRE_SWAMP = Restrictions.makeKey(TFBiomes.FIRE_SWAMP.location());
    public static final ResourceKey<Restriction> GLACIER = Restrictions.makeKey(TFBiomes.GLACIER.location());
    public static final ResourceKey<Restriction> HIGHLANDS = Restrictions.makeKey(TFBiomes.HIGHLANDS.location());
    public static final ResourceKey<Restriction> SNOWY_FOREST = Restrictions.makeKey(TFBiomes.SNOWY_FOREST.location());
    public static final ResourceKey<Restriction> SWAMP = Restrictions.makeKey(TFBiomes.SWAMP.location());
    public static final ResourceKey<Restriction> THORNLANDS = Restrictions.makeKey(TFBiomes.THORNLANDS.location());

    private static ResourceKey<Restriction> makeKey(ResourceLocation name) {
        return ResourceKey.create(TFRegistries.Keys.RESTRICTIONS, (ResourceLocation)name);
    }

    public static void bootstrap(BootstrapContext<Restriction> context) {
        context.register(DARK_FOREST, (Object)new Restriction(TFStructures.KNIGHT_STRONGHOLD, (ResourceKey<Enforcement>)Enforcements.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.register(DARK_FOREST_CENTER, (Object)new Restriction(TFStructures.DARK_TOWER, (ResourceKey<Enforcement>)Enforcements.DARKNESS.getKey(), 0.0f, Restrictions.asStack(TFBlocks.KNIGHT_PHANTOM_TROPHY), List.of(TwilightForestMod.prefix("progress_knights"))));
        context.register(FINAL_PLATEAU, (Object)new Restriction(TFStructures.FINAL_CASTLE, (ResourceKey<Enforcement>)Enforcements.ACID_RAIN.getKey(), 1.5f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll"))));
        context.register(FIRE_SWAMP, (Object)new Restriction(TFStructures.HYDRA_LAIR, (ResourceKey<Enforcement>)Enforcements.FIRE.getKey(), 8.0f, Restrictions.asStack(TFItems.MEEF_STROGANOFF), List.of(TwilightForestMod.prefix("progress_labyrinth"))));
        context.register(GLACIER, (Object)new Restriction(TFStructures.AURORA_PALACE, (ResourceKey<Enforcement>)Enforcements.FROST.getKey(), 1.0f, Restrictions.asStack(TFItems.ALPHA_YETI_FUR), List.of(TwilightForestMod.prefix("progress_yeti"))));
        context.register(HIGHLANDS, (Object)new Restriction(TFStructures.TROLL_CAVE, (ResourceKey<Enforcement>)Enforcements.ACID_RAIN.getKey(), 0.5f, Restrictions.asStack(TFBlocks.UBEROUS_SOIL), List.of(TwilightForestMod.prefix("progress_merge"))));
        context.register(SNOWY_FOREST, (Object)new Restriction(TFStructures.YETI_CAVE, (ResourceKey<Enforcement>)Enforcements.FROST.getKey(), 0.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.register(SWAMP, (Object)new Restriction(TFStructures.LABYRINTH, (ResourceKey<Enforcement>)Enforcements.HUNGER.getKey(), 1.0f, Restrictions.asStack(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE), List.of(TwilightForestMod.prefix("progress_lich"))));
        context.register(THORNLANDS, (Object)new Restriction(TFStructures.FINAL_CASTLE, (ResourceKey<Enforcement>)Enforcements.ACID_RAIN.getKey(), 1.0f, Restrictions.asStack(TFItems.LAMP_OF_CINDERS), List.of(TwilightForestMod.prefix("progress_troll"))));
    }

    public static ItemStack asStack(ItemLike itemLike) {
        return new ItemStack(itemLike);
    }
}

