/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.entity.ai.goal.FlockToSameKindGoal;
import twilightforest.entity.ai.goal.PanicOnFlockDeathGoal;
import twilightforest.init.TFSounds;
import twilightforest.network.ParticlePacket;

public class Kobold
extends Monster {
    private static final EntityDataAccessor<Boolean> PANICKED = SynchedEntityData.defineId(Kobold.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int lastEatenBreadTicks;
    private int eatingTime;

    public Kobold(EntityType<? extends Kobold> type, Level world) {
        super(type, world);
        this.setCanPickUpLoot(true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicOnFlockDeathGoal((PathfinderMob)this, 2.0f));
        this.goalSelector.addGoal(2, (Goal)new SeekBreadGoal(this));
        this.goalSelector.addGoal(2, (Goal)new RunAwayWhileHoldingBreadGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new FlockToSameKindGoal((Mob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new KoboldAttackPlayerTarget(this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PANICKED, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 13.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.KOBOLD_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.KOBOLD_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.KOBOLD_DEATH.get();
    }

    public boolean isPanicked() {
        return (Boolean)this.getEntityData().get(PANICKED);
    }

    public void setPanicked(boolean flag) {
        this.getEntityData().set(PANICKED, (Object)flag);
    }

    public SoundEvent getEatingSound(ItemStack stack) {
        return (SoundEvent)TFSounds.KOBOLD_MUNCH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide() && this.isPanicked()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth() * 0.5, this.getY() + (double)this.getEyeHeight(), this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth() * 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (!this.level().isClientSide() && this.isAlive() && this.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
            ItemStack itemstack;
            ++this.lastEatenBreadTicks;
            if (this.eatingTime > 0) {
                --this.eatingTime;
            }
            if (this.canEat(itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND))) {
                ItemStack itemstack1;
                if (this.eatingTime <= 0 && !(itemstack1 = itemstack.finishUsingItem(this.level(), (LivingEntity)this)).isEmpty()) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, itemstack1);
                }
                if (this.lastEatenBreadTicks > 60 && this.getRandom().nextFloat() < 0.1f) {
                    this.playSound(this.getEatingSound(itemstack), 0.75f, 0.9f);
                    this.gameEvent((Holder)GameEvent.EAT);
                    this.level().broadcastEntityEvent((Entity)this, (byte)45);
                    this.lastEatenBreadTicks = 0;
                }
            }
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 45) {
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.MAINHAND);
            if (!itemstack.isEmpty()) {
                this.spawnItemParticles(itemstack, 8);
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    private void spawnItemParticles(ItemStack stack, int amount) {
        ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.ITEM, stack);
        if (this.level().isClientSide()) {
            for (int i = 0; i < amount; ++i) {
                this.getItemParticleVectors((arg_0, arg_1) -> this.lambda$spawnItemParticles$0((ParticleOptions)particleOptions, arg_0, arg_1));
            }
        } else {
            ParticlePacket particlePacket = new ParticlePacket();
            for (int i = 0; i < amount; ++i) {
                this.getItemParticleVectors((arg_0, arg_1) -> this.lambda$spawnItemParticles$1(particlePacket, (ParticleOptions)particleOptions, arg_0, arg_1));
            }
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)particlePacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void getItemParticleVectors(BiConsumer<Vec3, Vec3> consumer) {
        Vec3 vec3 = new Vec3(((double)this.getRandom().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
        vec3 = vec3.yRot(-this.getYHeadRot() * ((float)Math.PI / 180));
        double d0 = (double)(-this.getRandom().nextFloat()) * 0.6 - 0.3;
        Vec3 vec31 = new Vec3(((double)this.getRandom().nextFloat() - 0.5) * 0.3, d0, 0.6);
        vec31 = vec31.xRot(-this.getXRot() * ((float)Math.PI / 180));
        vec31 = vec31.yRot(-this.getYHeadRot() * ((float)Math.PI / 180));
        vec31 = vec31.add(this.getX(), this.getEyeY(), this.getZ());
        consumer.accept(vec31, vec3);
    }

    private boolean canEat(ItemStack stack) {
        return stack.get(DataComponents.FOOD) != null && !this.isPanicked();
    }

    public boolean canTakeItem(ItemStack stack) {
        EquipmentSlot equipmentslot = this.getEquipmentSlotForItem(stack);
        if (!this.getItemBySlot(equipmentslot).isEmpty()) {
            return false;
        }
        return equipmentslot == EquipmentSlot.MAINHAND && super.canTakeItem(stack);
    }

    public boolean canHoldItem(ItemStack stack) {
        return this.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty() && stack.is(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS) && !this.isPanicked();
    }

    protected void pickUpItem(ItemEntity item) {
        ItemStack itemstack = item.getItem();
        if (this.canHoldItem(itemstack)) {
            int i = itemstack.getCount();
            if (i > 1) {
                this.dropItemStack(itemstack.split(i - 1));
            }
            this.onItemPickup(item);
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack.split(1));
            this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 2.0f;
            this.take((Entity)item, itemstack.getCount());
            this.gameEvent((Holder)GameEvent.EQUIP);
            item.discard();
            this.lastEatenBreadTicks = 1;
            this.eatingTime = this.difficultyTime() + this.getRandom().nextInt(600);
            this.setTarget(null);
        }
    }

    private int difficultyTime() {
        switch (this.level().getDifficulty()) {
            case EASY: {
                return 400;
            }
            case NORMAL: {
                return 200;
            }
            case HARD: {
                return 100;
            }
        }
        return 200;
    }

    private void dropItemStack(ItemStack stack) {
        ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)itementity);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("EatingTimeLeft", this.eatingTime);
        tag.putInt("TimeSinceBreadLastEaten", this.lastEatenBreadTicks);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.eatingTime = tag.getInt("EatingTimeLeft");
        this.lastEatenBreadTicks = tag.getInt("TimeSinceBreadLastEaten");
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    private /* synthetic */ void lambda$spawnItemParticles$1(ParticlePacket particlePacket, ParticleOptions particleOptions, Vec3 vec31, Vec3 vec3) {
        particlePacket.queueParticle(particleOptions, false, vec31.x() + vec3.x() * this.random.nextGaussian(), vec31.y() + (vec3.y() + 0.05) * this.random.nextGaussian(), vec31.z() + vec3.z() * this.random.nextGaussian(), 0.0, 0.0, 0.0);
    }

    private /* synthetic */ void lambda$spawnItemParticles$0(ParticleOptions particleOptions, Vec3 vec31, Vec3 vec3) {
        this.level().addParticle(particleOptions, vec31.x(), vec31.y(), vec31.z(), vec3.x(), vec3.y() + 0.05, vec3.z());
    }

    private static class SeekBreadGoal
    extends Goal {
        private static final Predicate<ItemEntity> ALLOWED_ITEMS = item -> item.getItem().is(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS);
        private final Kobold mob;

        public SeekBreadGoal(Kobold mob) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean canUse() {
            if (!this.mob.getUseItem().isEmpty()) {
                return false;
            }
            if (!this.mob.isPanicked()) {
                if (this.mob.getRandom().nextInt(10) != 0) {
                    return false;
                }
                List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && this.mob.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
            }
            return false;
        }

        public void tick() {
            List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack itemstack = this.mob.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemstack.isEmpty() && !list.isEmpty()) {
                this.mob.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
                this.mob.getLookControl().setLookAt(((ItemEntity)list.get(0)).getX(), ((ItemEntity)list.get(0)).getY(), ((ItemEntity)list.get(0)).getZ());
            }
        }

        public void start() {
            List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                this.mob.getNavigation().moveTo((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private static class RunAwayWhileHoldingBreadGoal
    extends AvoidEntityGoal<Player> {
        public RunAwayWhileHoldingBreadGoal(Kobold mob) {
            super((PathfinderMob)mob, Player.class, 8.0f, 1.5, 1.5);
        }

        public boolean canUse() {
            if (this.mob.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
                return super.canUse();
            }
            return false;
        }
    }

    private static class KoboldAttackPlayerTarget
    extends NearestAttackableTargetGoal<Player> {
        public KoboldAttackPlayerTarget(Kobold mob) {
            super((Mob)mob, Player.class, true);
        }

        public boolean canUse() {
            if (this.mob.getItemBySlot(EquipmentSlot.MAINHAND).is(ItemTagGenerator.KOBOLD_PACIFICATION_BREADS)) {
                return false;
            }
            return super.canUse();
        }
    }
}

