/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss.bar;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import twilightforest.network.TFBossBarPacket;

public class ServerTFBossBar
extends ServerBossEvent {
    private int color;

    public ServerTFBossBar(Component name, int color, BossEvent.BossBarOverlay overlay) {
        super(name, BossEvent.BossBarColor.WHITE, overlay);
        this.color = color;
    }

    public int getBarColor() {
        return this.color;
    }

    public void addPlayer(ServerPlayer player) {
        if (this.players.add(player) && this.visible) {
            player.connection.send((CustomPacketPayload)new TFBossBarPacket.AddTFBossBarPacket(this));
        }
    }

    public void updateStyle(int color, BossEvent.BossBarOverlay overlay, boolean allowLerp) {
        boolean change = false;
        if (this.color != color) {
            this.color = color;
            change = true;
        }
        if (this.overlay != overlay) {
            this.overlay = overlay;
            change = true;
        }
        if (change) {
            this.players.forEach(serverPlayer -> serverPlayer.connection.send((CustomPacketPayload)new TFBossBarPacket.UpdateTFBossBarStylePacket(this, allowLerp)));
        }
    }
}

