/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.HydraMortarModel;
import twilightforest.entity.boss.HydraMortar;

public class HydraMortarRenderer
extends EntityRenderer<HydraMortar> {
    private static final ResourceLocation TEXTURE = TwilightForestMod.getModelTexture("hydramortar.png");
    private final HydraMortarModel mortarModel;

    public HydraMortarRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.mortarModel = new HydraMortarModel(context.bakeLayer(TFModelLayers.HYDRA_MORTAR));
    }

    public void render(HydraMortar entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light) {
        stack.pushPose();
        if ((float)entity.fuse - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)entity.fuse - partialTicks + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            stack.scale(f1, f1, f1);
        }
        float alpha = (1.0f - ((float)entity.fuse - partialTicks + 1.0f) / 100.0f) * 0.8f;
        VertexConsumer consumer = buffers.getBuffer(this.mortarModel.renderType(TEXTURE));
        this.mortarModel.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.colorFromFloat((float)0.075f, (float)1.0f, (float)1.0f, (float)1.0f));
        if (entity.fuse / 5 % 2 == 0) {
            consumer = buffers.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE));
            this.mortarModel.renderToBuffer(stack, consumer, light, OverlayTexture.pack((int)OverlayTexture.u((float)1.0f), (int)10), FastColor.ARGB32.colorFromFloat((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f));
        }
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(HydraMortar entity) {
        return TEXTURE;
    }
}

