/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBlocks;

public class TFChestRenderer<T extends ChestBlockEntity>
extends ChestRenderer<T> {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public TFChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(T entity, ChestType chestType) {
        EnumMap<ChestType, Material> b = MATERIALS.get(entity.getBlockState().getBlock());
        if (b == null) {
            return super.getMaterial(entity, chestType);
        }
        Material material = b.get(chestType);
        return material != null ? material : super.getMaterial(entity, chestType);
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type, boolean trapped) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.CHEST_SHEET, TwilightForestMod.prefix("entity/chest/" + type + "/" + (trapped ? "trapped" : "single"))));
        map.put(ChestType.LEFT, new Material(Sheets.CHEST_SHEET, TwilightForestMod.prefix("entity/chest/" + type + "/" + (trapped ? "trapped_left" : "left"))));
        map.put(ChestType.RIGHT, new Material(Sheets.CHEST_SHEET, TwilightForestMod.prefix("entity/chest/" + type + "/" + (trapped ? "trapped_right" : "right"))));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)TFBlocks.TWILIGHT_OAK_CHEST.get()), TFChestRenderer.chestMaterial("twilight", false));
        builder.put((Object)((Block)TFBlocks.CANOPY_CHEST.get()), TFChestRenderer.chestMaterial("canopy", false));
        builder.put((Object)((Block)TFBlocks.MANGROVE_CHEST.get()), TFChestRenderer.chestMaterial("mangrove", false));
        builder.put((Object)((Block)TFBlocks.DARK_CHEST.get()), TFChestRenderer.chestMaterial("darkwood", false));
        builder.put((Object)((Block)TFBlocks.TIME_CHEST.get()), TFChestRenderer.chestMaterial("time", false));
        builder.put((Object)((Block)TFBlocks.TRANSFORMATION_CHEST.get()), TFChestRenderer.chestMaterial("transformation", false));
        builder.put((Object)((Block)TFBlocks.MINING_CHEST.get()), TFChestRenderer.chestMaterial("mining", false));
        builder.put((Object)((Block)TFBlocks.SORTING_CHEST.get()), TFChestRenderer.chestMaterial("sorting", false));
        builder.put((Object)((Block)TFBlocks.TWILIGHT_OAK_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("twilight", true));
        builder.put((Object)((Block)TFBlocks.CANOPY_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("canopy", true));
        builder.put((Object)((Block)TFBlocks.MANGROVE_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("mangrove", true));
        builder.put((Object)((Block)TFBlocks.DARK_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("darkwood", true));
        builder.put((Object)((Block)TFBlocks.TIME_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("time", true));
        builder.put((Object)((Block)TFBlocks.TRANSFORMATION_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("transformation", true));
        builder.put((Object)((Block)TFBlocks.MINING_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("mining", true));
        builder.put((Object)((Block)TFBlocks.SORTING_TRAPPED_CHEST.get()), TFChestRenderer.chestMaterial("sorting", true));
        MATERIALS = builder.build();
    }
}

