/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record SyncConfigToServerPacket(String configName, SNBTCompoundTag config) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncConfigToServerPacket> TYPE = new CustomPacketPayload.Type(FTBLibrary.rl("sync_config_to_server_packet"));
    public static final StreamCodec<FriendlyByteBuf, SyncConfigToServerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SyncConfigToServerPacket::configName, SNBTCompoundTag.STREAM_CODEC, SyncConfigToServerPacket::config, SyncConfigToServerPacket::new);

    public static SyncConfigToServerPacket create(SNBTConfig config) {
        return new SyncConfigToServerPacket(config.getKey(), (SNBTCompoundTag)((Object)Util.make((Object)((Object)new SNBTCompoundTag()), config::write)));
    }

    public CustomPacketPayload.Type<SyncConfigToServerPacket> type() {
        return TYPE;
    }

    public static void handle(SyncConfigToServerPacket message, NetworkManager.PacketContext context) {
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2)) {
            context.queue(() -> {
                MinecraftServer server = sp.getServer();
                ConfigManager.getInstance().syncFromClient(message.configName, message.config, sp.getGameProfile().getName());
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    if (sp.getUUID().equals(player.getUUID())) continue;
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncConfigFromServerPacket(message.configName, message.config));
                }
            });
        }
    }
}

