/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public record XZ(int x, int z) {
    public static final Codec<XZ> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("x").forGetter(XZ::x), (App)Codec.INT.fieldOf("z").forGetter(XZ::z)).apply((Applicative)builder, XZ::new));
    public static StreamCodec<FriendlyByteBuf, XZ> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, XZ::x, (StreamCodec)ByteBufCodecs.INT, XZ::z, XZ::new);

    public static XZ of(int x, int z) {
        return new XZ(x, z);
    }

    public static XZ of(long singleLong) {
        return XZ.of((int)singleLong, (int)(singleLong >> 32));
    }

    public static XZ of(ChunkPos pos) {
        return XZ.of(pos.x, pos.z);
    }

    public static XZ chunkFromBlock(int x, int z) {
        return XZ.of(x >> 4, z >> 4);
    }

    public static XZ chunkFromBlock(Vec3i pos) {
        return XZ.chunkFromBlock(pos.getX(), pos.getZ());
    }

    public static XZ regionFromChunk(int x, int z) {
        return XZ.of(x >> 5, z >> 5);
    }

    public static XZ regionFromChunk(ChunkPos p) {
        return XZ.of(p.x >> 5, p.z >> 5);
    }

    public static XZ regionFromBlock(int x, int z) {
        return XZ.of(x >> 9, z >> 9);
    }

    public static XZ regionFromBlock(Vec3i pos) {
        return XZ.regionFromBlock(pos.getX(), pos.getZ());
    }

    public ChunkDimPos dim(ResourceKey<Level> type) {
        return new ChunkDimPos(type, this.x, this.z);
    }

    public ChunkDimPos dim(Level world) {
        return this.dim((ResourceKey<Level>)world.dimension());
    }

    public XZ offset(int ox, int oz) {
        return XZ.of(this.x + ox, this.z + oz);
    }

    public long toLong() {
        return ChunkPos.asLong((int)this.x, (int)this.z);
    }

    public String toRegionString() {
        return String.format("%05X-%05X", this.x + 60000, this.z + 60000);
    }
}

