/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util.automaton;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.SingleTermsEnum;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.TermsEnum;
import org.apache.lucene.ars_nouveau.internal.hppc.IntArrayList;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.BytesRefBuilder;
import org.apache.lucene.ars_nouveau.util.IntsRef;
import org.apache.lucene.ars_nouveau.util.RamUsageEstimator;
import org.apache.lucene.ars_nouveau.util.StringHelper;
import org.apache.lucene.ars_nouveau.util.UnicodeUtil;
import org.apache.lucene.ars_nouveau.util.automaton.Automata;
import org.apache.lucene.ars_nouveau.util.automaton.Automaton;
import org.apache.lucene.ars_nouveau.util.automaton.ByteRunAutomaton;
import org.apache.lucene.ars_nouveau.util.automaton.ByteRunnable;
import org.apache.lucene.ars_nouveau.util.automaton.NFARunAutomaton;
import org.apache.lucene.ars_nouveau.util.automaton.Operations;
import org.apache.lucene.ars_nouveau.util.automaton.Transition;
import org.apache.lucene.ars_nouveau.util.automaton.TransitionAccessor;
import org.apache.lucene.ars_nouveau.util.automaton.UTF32ToUTF8;

public class CompiledAutomaton
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(CompiledAutomaton.class);
    public final AUTOMATON_TYPE type;
    public final BytesRef term;
    public final ByteRunAutomaton runAutomaton;
    public final Automaton automaton;
    final NFARunAutomaton nfaRunAutomaton;
    public final BytesRef commonSuffixRef;
    public final boolean finite;
    public final int sinkState;
    private Transition transition = new Transition();

    public CompiledAutomaton(Automaton automaton) {
        this(automaton, false, true);
    }

    private static int findSinkState(Automaton automaton) {
        int numStates = automaton.getNumStates();
        Transition t = new Transition();
        int foundState = -1;
        for (int s = 0; s < numStates; ++s) {
            if (!automaton.isAccept(s)) continue;
            int count = automaton.initTransition(s, t);
            boolean isSinkState = false;
            for (int i = 0; i < count; ++i) {
                automaton.getNextTransition(t);
                if (t.dest != s || t.min != 0 || t.max != 255) continue;
                isSinkState = true;
                break;
            }
            if (!isSinkState) continue;
            foundState = s;
            break;
        }
        return foundState;
    }

    public CompiledAutomaton(Automaton automaton, boolean finite, boolean simplify) {
        this(automaton, finite, simplify, false);
    }

    public CompiledAutomaton(Automaton automaton, boolean finite, boolean simplify, boolean isBinary) {
        if (automaton.getNumStates() == 0) {
            automaton = new Automaton();
            automaton.createState();
        }
        if (simplify && automaton.isDeterministic()) {
            if (Operations.isEmpty(automaton)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = true;
                this.sinkState = -1;
                this.nfaRunAutomaton = null;
                return;
            }
            boolean isTotal = isBinary ? Operations.isTotal(automaton, 0, 255) : Operations.isTotal(automaton);
            if (isTotal) {
                this.type = AUTOMATON_TYPE.ALL;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = false;
                this.sinkState = -1;
                this.nfaRunAutomaton = null;
                return;
            }
            IntsRef singleton = Operations.getSingleton(automaton);
            if (singleton != null) {
                this.type = AUTOMATON_TYPE.SINGLE;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = true;
                this.term = isBinary ? StringHelper.intsRefToBytesRef(singleton) : new BytesRef(UnicodeUtil.newString(singleton.ints, singleton.offset, singleton.length));
                this.sinkState = -1;
                this.nfaRunAutomaton = null;
                return;
            }
        }
        this.type = AUTOMATON_TYPE.NORMAL;
        this.term = null;
        this.finite = finite;
        Automaton binary = isBinary ? automaton : new UTF32ToUTF8().convert(automaton);
        if (this.finite || automaton.getNumStates() + automaton.getNumTransitions() > 1000) {
            this.commonSuffixRef = null;
        } else {
            BytesRef suffix = Operations.getCommonSuffixBytesRef(binary);
            this.commonSuffixRef = suffix.length == 0 ? null : suffix;
        }
        if (!automaton.isDeterministic() && !binary.isDeterministic()) {
            this.automaton = null;
            this.runAutomaton = null;
            this.sinkState = -1;
            this.nfaRunAutomaton = new NFARunAutomaton(binary, 255);
        } else {
            binary = Operations.determinize(binary, Integer.MAX_VALUE);
            this.runAutomaton = new ByteRunAutomaton(binary, true);
            this.automaton = this.runAutomaton.automaton;
            this.sinkState = CompiledAutomaton.findSinkState(this.automaton);
            this.nfaRunAutomaton = null;
        }
    }

    private BytesRef addTail(int state, BytesRefBuilder term, int idx, int leadLabel) {
        int maxIndex = -1;
        int numTransitions = this.automaton.initTransition(state, this.transition);
        int i = 0;
        while (i < numTransitions) {
            this.automaton.getNextTransition(this.transition);
            if (this.transition.min >= leadLabel) break;
            maxIndex = i++;
        }
        assert (maxIndex != -1);
        this.automaton.getTransition(state, maxIndex, this.transition);
        int floorLabel = this.transition.max > leadLabel - 1 ? leadLabel - 1 : this.transition.max;
        term.grow(1 + idx);
        term.setByteAt(idx, (byte)floorLabel);
        state = this.transition.dest;
        ++idx;
        while (true) {
            if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                assert (this.runAutomaton.isAccept(state));
                term.setLength(idx);
                return term.get();
            }
            this.automaton.getTransition(state, numTransitions - 1, this.transition);
            term.grow(1 + idx);
            term.setByteAt(idx, (byte)this.transition.max);
            state = this.transition.dest;
            ++idx;
        }
    }

    public TermsEnum getTermsEnum(Terms terms) throws IOException {
        switch (this.type.ordinal()) {
            case 0: {
                return TermsEnum.EMPTY;
            }
            case 1: {
                return terms.iterator();
            }
            case 2: {
                return new SingleTermsEnum(terms.iterator(), this.term);
            }
            case 3: {
                return terms.intersect(this, null);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    public void visit(QueryVisitor visitor, Query parent, String field) {
        if (visitor.acceptField(field)) {
            switch (this.type.ordinal()) {
                case 3: {
                    visitor.consumeTermsMatching(parent, field, () -> this.runAutomaton);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    visitor.consumeTermsMatching(parent, field, () -> new ByteRunAutomaton(Automata.makeAnyString()));
                    break;
                }
                case 2: {
                    visitor.consumeTerms(parent, new Term(field, this.term));
                }
            }
        }
    }

    public BytesRef floor(BytesRef input, BytesRefBuilder output) {
        int state = 0;
        if (input.length == 0) {
            if (this.runAutomaton.isAccept(state)) {
                output.clear();
                return output.get();
            }
            return null;
        }
        IntArrayList stack = new IntArrayList();
        int idx = 0;
        while (true) {
            int label = input.bytes[input.offset + idx] & 0xFF;
            int nextState = this.runAutomaton.step(state, label);
            if (idx == input.length - 1) {
                if (nextState != -1 && this.runAutomaton.isAccept(nextState)) {
                    output.grow(1 + idx);
                    output.setByteAt(idx, (byte)label);
                    output.setLength(input.length);
                    return output.get();
                }
                nextState = -1;
            }
            if (nextState == -1) {
                while (true) {
                    int numTransitions;
                    if ((numTransitions = this.automaton.getNumTransitions(state)) == 0) {
                        assert (this.runAutomaton.isAccept(state));
                        output.setLength(idx);
                        return output.get();
                    }
                    this.automaton.getTransition(state, 0, this.transition);
                    if (label - 1 >= this.transition.min) break;
                    if (this.runAutomaton.isAccept(state)) {
                        output.setLength(idx);
                        return output.get();
                    }
                    if (stack.size() == 0) {
                        return null;
                    }
                    state = stack.removeLast();
                    label = input.bytes[input.offset + --idx] & 0xFF;
                }
                return this.addTail(state, output, idx, label);
            }
            output.grow(1 + idx);
            output.setByteAt(idx, (byte)label);
            stack.add(state);
            state = nextState;
            ++idx;
        }
    }

    public ByteRunnable getByteRunnable() {
        assert (this.nfaRunAutomaton == null || this.runAutomaton == null);
        if (this.nfaRunAutomaton == null) {
            return this.runAutomaton;
        }
        return this.nfaRunAutomaton;
    }

    public TransitionAccessor getTransitionAccessor() {
        assert (this.nfaRunAutomaton == null || this.automaton == null);
        if (this.nfaRunAutomaton == null) {
            return this.automaton;
        }
        return this.nfaRunAutomaton;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.runAutomaton == null ? 0 : this.runAutomaton.hashCode());
        result = 31 * result + (this.nfaRunAutomaton == null ? 0 : this.nfaRunAutomaton.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompiledAutomaton other = (CompiledAutomaton)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.type == AUTOMATON_TYPE.SINGLE) {
            if (!this.term.equals(other.term)) {
                return false;
            }
        } else if (this.type == AUTOMATON_TYPE.NORMAL) {
            return Objects.equals(this.runAutomaton, other.runAutomaton) && Objects.equals(this.nfaRunAutomaton, other.nfaRunAutomaton);
        }
        return true;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.automaton) + RamUsageEstimator.sizeOfObject(this.commonSuffixRef) + RamUsageEstimator.sizeOfObject(this.runAutomaton) + RamUsageEstimator.sizeOfObject(this.nfaRunAutomaton) + RamUsageEstimator.sizeOfObject(this.term) + RamUsageEstimator.sizeOfObject(this.transition);
    }

    public static enum AUTOMATON_TYPE {
        NONE,
        ALL,
        SINGLE,
        NORMAL;

    }
}

