/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.sandbox.search.ProfilerCollectorResult;
import org.apache.lucene.ars_nouveau.sandbox.search.ProfilerCollectorWrapper;
import org.apache.lucene.ars_nouveau.search.Collector;
import org.apache.lucene.ars_nouveau.search.LeafCollector;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Weight;

public class ProfilerCollector
implements Collector {
    private final String collectorName;
    private final String reason;
    private final ProfilerCollectorWrapper collector;
    private final List<ProfilerCollector> children;

    public ProfilerCollector(Collector collector, String reason, List<ProfilerCollector> children) {
        this.collector = new ProfilerCollectorWrapper(collector);
        this.reason = reason;
        this.collectorName = this.deriveCollectorName(collector);
        this.children = children;
    }

    public long getTime() {
        return this.collector.getTime();
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    protected String deriveCollectorName(Collector c) {
        return c.getClass().getSimpleName();
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.collector.getLeafCollector(context);
    }

    @Override
    public void setWeight(Weight weight) {
        this.collector.setWeight(weight);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }

    public ProfilerCollectorResult getProfileResult() {
        return ProfilerCollector.doGetCollectorTree(this);
    }

    private static ProfilerCollectorResult doGetCollectorTree(ProfilerCollector collector) {
        ArrayList<ProfilerCollectorResult> childResults = new ArrayList<ProfilerCollectorResult>(collector.children.size());
        for (ProfilerCollector child : collector.children) {
            ProfilerCollectorResult result = ProfilerCollector.doGetCollectorTree(child);
            childResults.add(result);
        }
        return new ProfilerCollectorResult(collector.getName(), collector.getReason(), collector.getTime(), childResults);
    }
}

