/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event.timed;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.spell.rewind.IRewindCallback;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindAttachment;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindEntityData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class RewindEvent
implements ITimedEvent {
    @Nullable
    public Entity entity;
    public boolean doneRewinding;
    public int rewindTicks;
    public int ticksToRewind;
    public boolean respectsGravity;
    @Nullable
    public SpellContext context;
    public boolean serverSide;
    public long startGameTime;
    public boolean registeredEvents;

    public RewindEvent(long gameTime, int ticksToRewind, @Nullable SpellContext spellContext) {
        this.startGameTime = gameTime;
        this.ticksToRewind = ticksToRewind;
        this.context = spellContext;
    }

    public RewindEvent(@Nullable Entity entity, long gameTime, int ticksToRewind) {
        this(gameTime, ticksToRewind, null);
        this.entity = entity;
        this.respectsGravity = entity != null && !entity.isNoGravity();
    }

    public RewindEvent(@Nullable Entity entity, long gameTime, int ticksToRewind, @Nullable SpellContext context) {
        this(entity, gameTime, ticksToRewind);
        this.context = context;
    }

    @Override
    public void tick(boolean serverSide) {
        this.serverSide = serverSide;
        if (!this.registeredEvents && this.serverSide) {
            if (this.entity instanceof ServerPlayer) {
                NeoForge.EVENT_BUS.addListener(this::onEntityRemoved);
            }
            this.registeredEvents = true;
        }
        long eventGameTime = this.startGameTime - (long)this.rewindTicks;
        Entity entity = this.entity;
        if (entity instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)entity;
            rewindable.setRewinding(true);
            if (!rewindable.getMotions().empty()) {
                RewindEntityData data = rewindable.getMotions().pop();
                data.onRewind(this);
            }
        }
        if (this.context != null) {
            RewindAttachment rewindAttachment = RewindAttachment.get(this.context);
            List<IRewindCallback> contextData = rewindAttachment.getForTime(eventGameTime);
            rewindAttachment.setLockedTime(eventGameTime);
            if (contextData != null) {
                for (IRewindCallback callback : contextData) {
                    callback.onRewind(this);
                }
            }
            rewindAttachment.setLockedTime(-1L);
        }
        ++this.rewindTicks;
        if (this.rewindTicks >= this.ticksToRewind) {
            this.stop();
        }
    }

    public void stop() {
        this.doneRewinding = true;
        Entity entity = this.entity;
        if (entity instanceof IRewindable) {
            IRewindable rewindable = (IRewindable)entity;
            rewindable.setRewinding(false);
            this.entity.setDeltaMovement(Vec3.ZERO);
            this.removeWeightlessness();
        }
    }

    @Override
    public void onServerStopping() {
        this.removeWeightlessness();
    }

    public void onEntityRemoved(PlayerEvent.PlayerLoggedOutEvent event) {
        if (this.entity == null) {
            NeoForge.EVENT_BUS.unregister((Object)this);
            return;
        }
        if (this.entity == event.getEntity()) {
            this.removeWeightlessness();
            NeoForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public void removeWeightlessness() {
        if (!this.respectsGravity) {
            return;
        }
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            AttributeInstance weight = le.getAttribute(PerkAttributes.WEIGHT);
            if (weight != null) {
                weight.removeModifier(ArsNouveau.prefix("rewind"));
            }
        } else if (this.entity != null) {
            this.entity.setNoGravity(false);
        }
    }

    @Override
    public boolean isExpired() {
        return this.doneRewinding;
    }
}

