/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyPotionBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class PotionStoreGoal
extends GoToPosGoal<StarbyPotionBehavior> {
    public PotionStoreGoal(Starbuncle starbuncle, StarbyPotionBehavior behavior) {
        super(starbuncle, behavior, () -> behavior.getHeldPotion() != PotionContents.EMPTY);
    }

    @Override
    public void start() {
        super.start();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.STORING_ITEM;
    }

    @Override
    @Nullable
    public BlockPos getDestination() {
        return ((StarbyPotionBehavior)this.behavior).getJarForStorage(((StarbyPotionBehavior)this.behavior).getHeldPotion());
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyPotionBehavior)this.behavior).isPositionValidStore(pos, ((StarbyPotionBehavior)this.behavior).getHeldPotion());
    }

    @Override
    public boolean onDestinationReached() {
        BlockEntity blockEntity = this.starbuncle.level.getBlockEntity(this.targetPos);
        if (blockEntity instanceof PotionJarTile) {
            PotionJarTile jarTile = (PotionJarTile)blockEntity;
            int room = jarTile.getMaxFill() - jarTile.getAmount();
            int diff = Math.min(room, ((StarbyPotionBehavior)this.behavior).getAmount());
            jarTile.add(((StarbyPotionBehavior)this.behavior).getHeldPotion(), diff);
            ((StarbyPotionBehavior)this.behavior).setHeldPotion(PotionContents.EMPTY);
            this.starbuncle.level.playSound(null, this.targetPos, SoundEvents.BUCKET_EMPTY, SoundSource.NEUTRAL, 0.5f, 1.3f);
            ((StarbyPotionBehavior)this.behavior).setAmount(((StarbyPotionBehavior)this.behavior).getAmount() - diff);
        }
        return true;
    }
}

