/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.entity.goal.DistanceRestrictedGoal;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;

public class GoBackHomeGoal
extends DistanceRestrictedGoal {
    Mob entity;
    Supplier<Boolean> shouldGo;

    public GoBackHomeGoal(Mob entity, Supplier<BlockPos> pos, int maxDistance) {
        super(pos, maxDistance);
        this.entity = entity;
        this.shouldGo = () -> true;
    }

    public GoBackHomeGoal(Mob entity, Supplier<BlockPos> pos, int maxDistance, Supplier<Boolean> shouldGo) {
        super(pos, maxDistance);
        this.entity = entity;
        this.shouldGo = shouldGo;
    }

    public void tick() {
        if (this.positionFrom.get() != null && BlockUtil.distanceFrom(this.entity.blockPosition(), (BlockPos)this.positionFrom.get()) > 5.0) {
            BlockPos homePos = (BlockPos)this.positionFrom.get();
            this.entity.getNavigation().moveTo((double)homePos.getX(), (double)homePos.getY(), (double)homePos.getZ(), 1.5);
        }
    }

    public boolean canContinueToUse() {
        return this.positionFrom != null && BlockUtil.distanceFrom(this.entity.blockPosition(), (BlockPos)this.positionFrom.get()) > 5.0 && this.shouldGo.get() != false;
    }

    public boolean canUse() {
        return this.positionFrom != null && this.entity.level.random.nextFloat() < 0.02f && !this.isInRange(this.entity.blockPosition()) && this.shouldGo.get() != false;
    }
}

