/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.PrestidigitationTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IResolveListener;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectDispel;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectPrestidigitation;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DecorBlossomTile
extends ModdedTile
implements ITickable,
IWandable,
IResolveListener,
GeoBlockEntity {
    protected PrestidigitationTimeline timeline;
    protected ParticleEmitter emitter;
    protected BlockPos emitPos;
    AnimationController openCloseController;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DecorBlossomTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.DECOR_BLOSSOM_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        if (this.timeline != null && this.level.isClientSide && this.emitPos != null) {
            if (this.emitter == null) {
                this.emitter = new ParticleEmitter(() -> this.emitPos.getCenter(), () -> new Vec2(0.0f, 0.0f), this.timeline.onTickEffect);
            }
            this.emitter.tick(this.level);
        }
    }

    public void onRandomTick() {
        if (this.timeline != null && this.timeline.randomSound != null && this.timeline.randomSound.sound != null && this.emitPos != null) {
            this.timeline.randomSound.sound.playSound(this.level, this.emitPos.getCenter());
        }
    }

    @Override
    public IWandable.Result onFirstConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null) {
            return IWandable.super.onFirstConnection(storedPos, face, storedEntity, playerEntity);
        }
        if (BlockUtil.distanceFrom(storedPos.pos(), this.worldPosition) > (double)((Integer)ServerConfig.DECOR_BLOSSOM_RANGE.get()).intValue()) {
            playerEntity.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.connection.range", (Object[])new Object[]{ServerConfig.DECOR_BLOSSOM_RANGE.get()}));
            return IWandable.Result.FAIL;
        }
        if (storedPos != null) {
            this.emitPos = storedPos.pos().above();
            this.updateBlock();
            return IWandable.Result.SUCCESS;
        }
        return IWandable.super.onFirstConnection(storedPos, face, storedEntity, playerEntity);
    }

    @Override
    public IWandable.Result onClearConnections(Player playerEntity) {
        this.emitPos = null;
        this.timeline = null;
        this.updateBlock();
        return IWandable.Result.SUCCESS;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.timeline != null) {
            tag.put("prestidigitation_timeline", ANCodecs.encode(PrestidigitationTimeline.CODEC.codec(), this.timeline));
        }
        if (this.emitPos != null) {
            tag.putLong("emitPos", this.emitPos.asLong());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.timeline = null;
        this.emitPos = null;
        if (tag.contains("prestidigitation_timeline")) {
            this.timeline = (PrestidigitationTimeline)ANCodecs.decode(PrestidigitationTimeline.CODEC.codec(), (Tag)tag.getCompound("prestidigitation_timeline"));
        }
        if (tag.contains("emitPos")) {
            this.emitPos = BlockPos.of((long)tag.getLong("emitPos"));
        }
    }

    @Override
    public IResolveListener.ResolveStatus onPreResolve(Level world, @NotNull LivingEntity shooter, HitResult result, Spell spell, SpellContext spellContext, AbstractEffect resolveEffect, SpellStats spellStats, SpellResolver spellResolver) {
        if (resolveEffect instanceof EffectPrestidigitation) {
            this.timeline = (PrestidigitationTimeline)spell.particleTimeline().get((IParticleTimelineType)ParticleTimelineRegistry.PRESTIDIGITATION_TIMELINE.get());
            this.emitter = new ParticleEmitter(() -> this.emitPos.getCenter(), () -> new Vec2(0.0f, 0.0f), this.timeline.onTickEffect);
            this.updateBlock();
            return IResolveListener.ResolveStatus.CONSUME;
        }
        if (resolveEffect instanceof EffectDispel) {
            EffectDispel dispel = (EffectDispel)resolveEffect;
            this.timeline = null;
            this.updateBlock();
        }
        return IResolveListener.ResolveStatus.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.openCloseController = new AnimationController((GeoAnimatable)this, "openClose", event -> {
            event.getController().setAnimation(RawAnimation.begin().thenPlayAndHold(this.timeline == null ? "close" : "open"));
            return PlayState.CONTINUE;
        });
        controllers.add(this.openCloseController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

