/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.ScribesBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.crafting.recipes.GlyphRecipe;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;

public class ScribesRenderer
extends ArsGeoBlockRenderer<ScribesTile> {
    public static GeoModel model = new GenericModel("scribes_table");

    public ScribesRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, model);
    }

    @Override
    public void actuallyRender(PoseStack stack, ScribesTile tile, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        BlockState state = tile.getBlockState();
        if (state.getValue((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)ScribesBlock.FACING);
        stack.pushPose();
        if (direction == Direction.NORTH) {
            stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            stack.translate(1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.SOUTH) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            stack.translate(-1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.WEST) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            stack.translate(0.0f, 0.0f, -1.0f);
        }
        if (direction == Direction.EAST) {
            stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            stack.translate(0.0f, 0.0f, 1.0f);
        }
        super.actuallyRender(stack, tile, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        stack.popPose();
    }

    public void renderFinal(PoseStack stack, ScribesTile tile, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        BlockState state = tile.getBlockState();
        if (state.getBlock() != BlockRegistry.SCRIBES_BLOCK.get()) {
            return;
        }
        if (state.getValue((Property)ScribesBlock.PART) != ThreePartBlock.HEAD) {
            return;
        }
        this.renderPressedItem(tile, tile.crafting ? (tile.craftingTicks < 40 ? ((GlyphRecipe)tile.recipe.value()).output.getItem().getDefaultInstance() : ((ModItem)((Object)ItemsRegistry.BLANK_GLYPH.get())).getDefaultInstance()) : tile.getStack(), stack, bufferSource, packedLight, packedOverlay, (float)ClientInfo.ticksInGame + partialTick);
    }

    public void renderPressedItem(ScribesTile tile, ItemStack itemToRender, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int packedLight, int packedOverlay, float partialTicks) {
        BlockState state = tile.getBlockState();
        Direction direction = (Direction)state.getValue((Property)ScribesBlock.FACING);
        matrixStack.pushPose();
        matrixStack.translate(0.0, 1.0, 0.0);
        Quaternionf quat = Axis.ZP.rotationDegrees(90.0f);
        Vec3 translationOffset = new Vec3(0.0, 0.0, 0.0);
        if (direction == Direction.WEST) {
            matrixStack.translate(1.0f, 0.0f, 0.5f);
            quat = Axis.ZP.rotationDegrees(90.0f);
            translationOffset = new Vec3(1.0, 0.0, 0.5);
        }
        if (direction == Direction.EAST) {
            matrixStack.translate(0.0f, 0.0f, 0.5f);
            quat = Axis.ZP.rotationDegrees(270.0f);
            translationOffset = new Vec3(0.0, 0.0, 0.5);
        }
        if (direction == Direction.SOUTH) {
            matrixStack.translate(0.5f, 0.0f, 0.0f);
            quat = Axis.ZP.rotationDegrees(90.0f);
            translationOffset = new Vec3(0.5, 0.0, 0.0);
        }
        if (direction == Direction.NORTH) {
            matrixStack.translate(0.5f, 0.0f, 1.0f);
            quat = Axis.ZP.rotationDegrees(90.0f);
            translationOffset = new Vec3(0.5, 0.0, 1.0);
        }
        float y = ((Direction)state.getValue((Property)ScribesBlock.FACING)).getClockWise().toYRot();
        matrixStack.mulPose(Axis.YP.rotationDegrees(-y + 90.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(quat);
        matrixStack.scale(0.6f, 0.6f, 0.3f);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemToRender, ItemDisplayContext.FIXED, packedLight, packedOverlay, matrixStack, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), tile.getLevel(), (int)tile.getBlockPos().asLong());
        matrixStack.popPose();
        if (tile.recipe != null && !tile.crafting) {
            List<Ingredient> inputs = tile.getRemainingRequired();
            float ticks = partialTicks + (float)ClientInfo.ticksInGame;
            float angleBetweenEach = 360.0f / (float)inputs.size();
            Vec3 distanceVec = new Vec3(1.0, -0.5, 1.0);
            for (int i = 0; i < inputs.size(); ++i) {
                Ingredient ingredient = inputs.get(i);
                ItemStack stack = ingredient.getItems()[ClientInfo.ticksInGame / 20 % ingredient.getItems().length];
                matrixStack.pushPose();
                matrixStack.translate(0.0f, 2.0f, 0.0f);
                matrixStack.translate(translationOffset.x, translationOffset.y, translationOffset.z);
                matrixStack.scale(0.25f, 0.25f, 0.25f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(ticks + (float)i * angleBetweenEach));
                matrixStack.translate(distanceVec.x(), distanceVec.y() + (double)((float)(i % 2 == 0 ? -i : i) * Mth.sin((float)(ticks / 60.0f))) * 0.0625, distanceVec.z());
                matrixStack.mulPose((i % 2 == 0 ? Axis.ZP : Axis.XP).rotationDegrees(ticks));
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, matrixStack, (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), tile.getLevel(), (int)tile.getBlockPos().asLong());
                matrixStack.popPose();
            }
        }
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(model);
    }

    public RenderType getRenderType(ScribesTile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    public boolean shouldRenderOffScreen(ScribesTile pBlockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public AABB getRenderBoundingBox(ScribesTile blockEntity) {
        return AABB.INFINITE;
    }
}

