/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.client.particle.ColorParticleTypeData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.registry.ModParticles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class HelixParticleTypeData
extends ColorParticleTypeData {
    float angle;
    float radius;
    float radiusY;
    float speed;
    public static final MapCodec<HelixParticleTypeData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.color.getRed())), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.color.getGreen())), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.color.getBlue())), (App)Codec.BOOL.fieldOf("disableDepthTest").forGetter(d -> d.disableDepthTest), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(d -> Float.valueOf(d.alpha)), (App)Codec.INT.fieldOf("age").forGetter(d -> d.age), (App)Codec.FLOAT.fieldOf("angle").forGetter(d -> Float.valueOf(d.angle)), (App)Codec.FLOAT.fieldOf("radius").forGetter(d -> Float.valueOf(d.radius)), (App)Codec.FLOAT.fieldOf("radiusY").forGetter(d -> Float.valueOf(d.radiusY)), (App)Codec.FLOAT.fieldOf("speed").forGetter(d -> Float.valueOf(d.speed))).apply((Applicative)instance, HelixParticleTypeData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HelixParticleTypeData> STREAM_CODEC = StreamCodec.of(HelixParticleTypeData::toNetwork, HelixParticleTypeData::fromNetwork);

    public HelixParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age) {
        super(r, g, b, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        super(color, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float angle, float radius, float radiusY, float speed) {
        super(particleTypeData, color, disableDepthTest);
        this.angle = angle;
        this.radius = radius;
        this.radiusY = radiusY;
        this.speed = speed;
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age) {
        super(particleTypeData, color, disableDepthTest, size, alpha, age);
    }

    public HelixParticleTypeData(float r, float g, float b, boolean disableDepthTest, float size, float alpha, int age, float angle, float radius, float radiusY, float speed) {
        this((ParticleType<HelixParticleTypeData>)((ParticleType)ModParticles.HELIX_TYPE.get()), new ParticleColor(r, g, b), disableDepthTest, size, alpha, age, angle, radius, radiusY, speed);
    }

    public HelixParticleTypeData(ParticleType<HelixParticleTypeData> particleTypeData, ParticleColor color, boolean disableDepthTest, float size, float alpha, int age, float offset, float radius, float radiusY, float speed) {
        super(particleTypeData, color, disableDepthTest, size, alpha, age);
        this.angle = offset;
        this.radius = radius;
        this.radiusY = radiusY;
        this.speed = speed;
    }

    public static HelixParticleTypeData fromNetwork(RegistryFriendlyByteBuf buffer) {
        float r = buffer.readFloat();
        float g = buffer.readFloat();
        float b = buffer.readFloat();
        boolean disableDepthTest = buffer.readBoolean();
        float size = buffer.readFloat();
        float alpha = buffer.readFloat();
        int age = buffer.readInt();
        float angle = buffer.readFloat();
        float radius = buffer.readFloat();
        float radiusY = buffer.readFloat();
        float speed = buffer.readFloat();
        return new HelixParticleTypeData(r, g, b, disableDepthTest, size, alpha, age, angle, radius, radiusY, speed);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buf, HelixParticleTypeData data) {
        buf.writeFloat(data.color.getRed());
        buf.writeFloat(data.color.getGreen());
        buf.writeFloat(data.color.getBlue());
        buf.writeBoolean(data.disableDepthTest);
        buf.writeFloat(data.size);
        buf.writeFloat(data.alpha);
        buf.writeInt(data.age);
        buf.writeFloat(data.angle);
        buf.writeFloat(data.radius);
        buf.writeFloat(data.radiusY);
        buf.writeFloat(data.speed);
    }
}

